#!/usr/atria/bin/Perl
#------------------------------------------------------------
# ClearCase ClearMake Build Automation
#
# Rational Software Corporation.CopyRight 2002
#
#------------------------------------------------------------
#
$FolderPath = shift( @ARGV );
$Build = shift( @ARGV );

# Check if Argument exist
if ( !$FolderPath )
{
	print "Error: Project directory argument is missing\n";
	exit(0);
}
# Check Folder Path exist
if ( ! -e $FolderPath )
{
	print "Error: Project directory $FolderPath does not exist\n";
	exit(0);
}
# Check if Argument exist
if ( !$Build )
{
	print "Error: Project build argument is missing\n";
	exit(0);
}

# change directory
chdir($FolderPath);

$Output = `$Build`;

if (!$Output)
{
	print "Error running: $Build\n";
	exit(0);
}
else
{
	print "$Output\n";
}

exit(0);




