/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtt.gen.xsd.java.sdo.wizard;

import com.ibm.xtt.gen.xsd.java.sdo.WDOGenerator;
import com.ibm.xtt.gen.xsd.java.sdo.messages.Messages;
import com.ibm.xtt.gen.xsd.java.sdo.util.RuntimeJarsManager;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class SDOGeneratorCommand
extends AbstractDataModelOperation {
    private static final String[] jars = new String[]{"org.eclipse.emf.ecore.sdo", "org.eclipse.emf.commonj.sdo", "org.eclipse.emf.ecore.xmi", "org.eclipse.emf.ecore", "org.eclipse.emf.common"};
    private String projectName;
    private String outputLocation;
    private GenJDKLevel complianceLevel;
    private IStructuredSelection initialSelection;
    private boolean generationSucesfull = false;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        monitor.beginTask(String.valueOf(Messages._UI_JAVA_GEN_SELECTION_PAGE_TITLE) + "...", -1);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor shellMonitor) throws InvocationTargetException, InterruptedException {
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        WDOGenerator wdogen = new WDOGenerator();
                        IPath schemaPath = ((IFile)SDOGeneratorCommand.this.initialSelection.getFirstElement()).getLocation();
                        String xmlSchema = schemaPath.toOSString();
                        try {
                            RuntimeJarsManager.addRuntimeJars(jars, SDOGeneratorCommand.this.projectName);
                            wdogen.setModelDirectoryName(SDOGeneratorCommand.this.outputLocation);
                            wdogen.setComplianceLevel(SDOGeneratorCommand.this.complianceLevel);
                            wdogen.generate(URI.createFileURI((String)xmlSchema));
                            SDOGeneratorCommand.this.generationSucesfull = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(SDOGeneratorCommand.this.outputLocation));
                        res.refreshLocal(2, null);
                    }
                };
                operation.run(null);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        monitor.done();
        if (this.generationSucesfull) {
            Shell shell = Display.getCurrent().getActiveShell();
            MessageDialog.openInformation((Shell)shell, (String)Messages._UI_DIALOG_GENERATION_SUCCESS_TITLE, (String)Messages._UI_DIALOG_GENERATION_SUCCESS_MESSAGE);
        }
        return status;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public GenJDKLevel getComplianceLevel() {
        return this.complianceLevel;
    }

    public void setComplianceLevel(GenJDKLevel complianceLevel) {
        this.complianceLevel = complianceLevel;
    }

    public IStructuredSelection getInitialSelection() {
        return this.initialSelection;
    }

    public void setInitialSelection(IStructuredSelection initialSelection) {
        this.initialSelection = initialSelection;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String javaProjectName) {
        this.projectName = javaProjectName;
    }
}

