/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtt.gen.xsd.java.sdo.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class RuntimeJarsManager {
    public static void addRuntimeJars(String[] runtimeJars, String javaProjectName) throws JavaModelException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(javaProjectName);
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspaceRoot);
        String[] classpath = RuntimeJarsManager.processClassPath(runtimeJars);
        IJavaProject javaProject = javaModel.getJavaProject(project.getName());
        IClasspathEntry[] classpathEntries = RuntimeJarsManager.buildClasspathEntries(javaProject, classpath);
        javaProject.setRawClasspath(classpathEntries, null);
    }

    private static IClasspathEntry[] buildClasspathEntries(IJavaProject project, String[] classpath) throws JavaModelException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] otherEntries = project.getResolvedClasspath(true);
        IClasspathEntry[] cp = project.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            list.add(cp[i]);
            ++i;
        }
        IClasspathEntry cpEntry = null;
        Path path = null;
        int i2 = 0;
        while (i2 < classpath.length) {
            path = new Path(classpath[i2]);
            cpEntry = JavaCore.newLibraryEntry((IPath)path, null, null);
            if (!RuntimeJarsManager.isEntryInList(otherEntries, cpEntry)) {
                list.add(i2 + 1, cpEntry);
            }
            ++i2;
        }
        IClasspathEntry[] result = new IClasspathEntry[list.size()];
        list.toArray(result);
        return result;
    }

    private static String[] processClassPath(String[] jars) {
        ArrayList libs = new ArrayList();
        int i = 0;
        while (i < jars.length) {
            try {
                libs.addAll(RuntimeJarsManager.resolvePluginPath(jars[i]));
            }
            catch (JETException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return libs.toArray(new String[libs.size()]);
    }

    private static List resolvePluginPath(String pluginID) throws JETException {
        ArrayList<String> result;
        block10: {
            result = new ArrayList<String>();
            try {
                int i;
                ManifestElement[] elements;
                Bundle bundle = Platform.getBundle((String)pluginID);
                String requires = (String)bundle.getHeaders().get("Bundle-ClassPath");
                if (requires == null) {
                    requires = ".";
                }
                if ((elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requires)) == null || (i = 0) >= elements.length) break block10;
                ManifestElement element = elements[i];
                String value = element.getValue();
                if (".".equals(value)) {
                    value = "/";
                }
                try {
                    URL url = bundle.getEntry(value);
                    if (url != null) {
                        URL resolvedURL = FileLocator.resolve((URL)url);
                        String resolvedURLString = resolvedURL.toString();
                        if (resolvedURLString.endsWith("!/")) {
                            resolvedURLString = resolvedURL.getFile();
                            resolvedURLString = resolvedURLString.substring(0, resolvedURLString.length() - "!/".length());
                        }
                        if (resolvedURLString.startsWith("file:")) {
                            result.add(resolvedURLString.substring("file:".length()));
                        } else {
                            result.add(FileLocator.toFileURL((URL)url).getFile());
                        }
                    }
                }
                catch (IOException exception) {
                    throw new JETException((Throwable)exception);
                }
            }
            catch (BundleException exception) {
                throw new JETException((Throwable)exception);
            }
        }
        return result;
    }

    private static boolean isEntryInList(IClasspathEntry[] entries, IClasspathEntry entry) {
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getPath().equals((Object)entry.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

