/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtt.gen.xsd.java.sdo.dialogs;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

final class ResourceFilter
extends ViewerFilter {
    private String[] fExtensions;
    private IFile[] fExcludedFiles;
    private Collection fExcludes;

    public ResourceFilter(String[] extensions, Collection exclude) {
        this.fExtensions = extensions;
        this.fExcludes = exclude;
        this.fExcludedFiles = null;
    }

    public ResourceFilter(String[] extensions, IFile[] excludedFiles, Collection exclude) {
        this.fExtensions = extensions;
        this.fExcludes = exclude;
        this.fExcludedFiles = excludedFiles;
    }

    public boolean isFilterProperty(Object element, Object property) {
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            if (this.fExcludes != null && this.fExcludes.contains(element)) {
                return false;
            }
            String name = ((IFile)element).getName();
            if (this.fExcludedFiles != null) {
                int j = 0;
                while (j < this.fExcludedFiles.length) {
                    if (((IFile)element).getLocation().toOSString().compareTo(this.fExcludedFiles[j].getLocation().toOSString()) == 0) {
                        return false;
                    }
                    ++j;
                }
            }
            if (this.fExtensions.length == 0) {
                return true;
            }
            int i = 0;
            while (i < this.fExtensions.length) {
                if (name.endsWith(this.fExtensions[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (element instanceof IContainer) {
            try {
                IResource[] resources = ((IContainer)element).members();
                int i = 0;
                while (i < resources.length) {
                    if (this.select(viewer, parent, resources[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }
}

