/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtt.gen.xsd.java.sdo.dialogs;

import com.ibm.xtt.gen.xsd.java.sdo.messages.Messages;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class JavaProjectSelectionView {
    private IJavaElement selectedJavaElement;
    private Object fInput;
    private boolean isFileMandatory;
    private TreeViewer sourceFileViewer;
    private Listener listener;
    private Vector fFilters;
    private IStructuredSelection selection;

    public JavaProjectSelectionView(IStructuredSelection selection, boolean isFileMandatory) {
        this.isFileMandatory = isFileMandatory;
        this.selectedJavaElement = null;
        this.selection = selection;
    }

    public Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 16384);
        label.setText(Messages._UI_LABEL_CHOOSE_FOLDER);
        data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        this.createSourceViewer(composite);
        return composite;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    protected void createSourceViewer(Composite parent) {
        this.sourceFileViewer = new TreeViewer(new Tree(parent, 2052));
        this.sourceFileViewer.setContentProvider((IContentProvider)new StandardJavaElementContentProvider());
        this.sourceFileViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        this.sourceFileViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean isComplete = true;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    List list = ((IStructuredSelection)selection).toList();
                    for (IJavaElement element : list) {
                        if (element instanceof IJavaProject) {
                            JavaProjectSelectionView.this.selectedJavaElement = (IJavaElement)((IJavaProject)element);
                            if (!JavaProjectSelectionView.this.isFileMandatory) continue;
                            isComplete = true;
                            break;
                        }
                        if (element instanceof IPackageFragmentRoot) {
                            JavaProjectSelectionView.this.selectedJavaElement = (IJavaElement)((IPackageFragmentRoot)element);
                            if (!JavaProjectSelectionView.this.isFileMandatory) continue;
                            isComplete = true;
                            break;
                        }
                        if (!JavaProjectSelectionView.this.isFileMandatory) continue;
                        isComplete = false;
                    }
                    if (JavaProjectSelectionView.this.listener != null) {
                        JavaProjectSelectionView.this.listener.setControlComplete(isComplete);
                    }
                }
            }
        });
        Tree treeWidget = this.sourceFileViewer.getTree();
        GridData gd = new GridData(1808);
        treeWidget.setLayoutData((Object)gd);
    }

    protected void setVisibleHelper(boolean visible) {
        if (visible) {
            if (this.fFilters != null) {
                this.sourceFileViewer.resetFilters();
                Iterator i = this.fFilters.iterator();
                while (i.hasNext()) {
                    this.sourceFileViewer.addFilter((ViewerFilter)i.next());
                }
            }
            this.sourceFileViewer.setInput(this.fInput);
            this.sourceFileViewer.expandToLevel(3);
            if (this.selection != null) {
                this.sourceFileViewer.setSelection((ISelection)this.selection, true);
            } else if (!this.sourceFileViewer.getSelection().isEmpty()) {
                this.sourceFileViewer.setSelection(this.sourceFileViewer.getSelection());
            } else if (this.isFileMandatory && this.listener != null) {
                this.listener.setControlComplete(false);
            }
        }
    }

    public IJavaElement getJavaElement() {
        return this.selectedJavaElement;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new Vector();
        }
        this.fFilters.add(filter);
    }

    public static interface Listener {
        public void setControlComplete(boolean var1);
    }
}

