/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtt.gen.xsd.java.sdo.dialogs;

import com.ibm.xtt.gen.xsd.java.sdo.dialogs.JavaProjectSelectionView;
import com.ibm.xtt.gen.xsd.java.sdo.dialogs.TypedViewerFilter;
import com.ibm.xtt.gen.xsd.java.sdo.messages.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JavaProjectSelectionDialog
extends Dialog {
    private JavaProjectSelectionView selectJavaProjectView;
    private Button okButton;

    public JavaProjectSelectionDialog(Shell parentShell, IStructuredSelection selection, boolean isFolderMandatory) {
        super(parentShell);
        if (selection == null) {
            selection = new StructuredSelection();
        }
        this.selectJavaProjectView = new JavaProjectSelectionView(selection, isFolderMandatory);
        Class[] acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            @Override
            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                    IJavaProject javaProj = javaModel.getJavaProject(project.getName());
                    if (javaProj.exists()) {
                        element = javaProj;
                    }
                }
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        ErrorDialog.openError((Shell)JavaProjectSelectionDialog.this.getShell(), (String)Messages._UI_ERROR, null, (IStatus)e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        this.selectJavaProjectView.addFilter(filter);
    }

    public int open(Object input) {
        this.setInput(input);
        return this.open();
    }

    public void setInput(Object input) {
        this.selectJavaProjectView.setInput(input);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 350;
        gd.heightHint = 350;
        composite.setLayoutData((Object)gd);
        JavaProjectSelectionView.Listener listener = new JavaProjectSelectionView.Listener(){

            @Override
            public void setControlComplete(boolean isComplete) {
                JavaProjectSelectionDialog.this.okButton.setEnabled(isComplete);
            }
        };
        this.selectJavaProjectView.setListener(listener);
        this.selectJavaProjectView.createControl(composite);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void create() {
        super.create();
        this.selectJavaProjectView.setVisibleHelper(true);
        this.getShell().setText(Messages._UI_LABEL_FOLDER_SELECTION);
    }

    public IJavaElement getJavaElement() {
        return this.selectJavaProjectView.getJavaElement();
    }
}

