/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.security.j2se;

import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.IRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.ImplementedInterfaceRuleFilter;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class ReferenceToSystemHandleRule
extends AbstractAnalysisRule {
    private static final String SERIALIZABLE_CLASS = "java.io.Serializable";
    private static final String FILE_CLASS = "java.io.File";
    private static final String SOCKET_CLASS = "java.net.Socket";

    public void analyze(AnalysisHistory history) {
        String historyId = history.getHistoryId();
        CodeReviewResource resource = (CodeReviewResource)this.getProvider().getProperty(historyId, "codereview.java.resource");
        List tds = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 55);
        ASTHelper.satisfy((List)tds, (IRuleFilter)new ImplementedInterfaceRuleFilter(SERIALIZABLE_CLASS, true));
        for (TypeDeclaration td : tds) {
            for (BodyDeclaration bd : td.bodyDeclarations()) {
                String qualifiedName;
                FieldDeclaration fd;
                ITypeBinding typeBinding;
                if (bd.getNodeType() != 23 || (typeBinding = (fd = (FieldDeclaration)bd).getType().resolveBinding()) == null || !FILE_CLASS.equals(qualifiedName = typeBinding.getQualifiedName()) && !SOCKET_CLASS.equals(qualifiedName) || Modifier.isTransient(fd.getModifiers())) continue;
                resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)fd);
            }
        }
    }
}

