/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.security.j2se;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

public class CatchingSecurityExceptionRule
extends AbstractAnalysisRule {
    private static final String JAVA_LANG_SECURITY_EXCEPTION = "java.lang.SecurityException";

    public void analyze(AnalysisHistory history) {
        String historyId = history.getHistoryId();
        CodeReviewResource resource = (CodeReviewResource)this.getProvider().getProperty(historyId, "codereview.java.resource");
        List ccs = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 12);
        for (CatchClause cc : ccs) {
            ITypeBinding binding;
            SingleVariableDeclaration svd = cc.getException();
            if (svd == null || (binding = svd.getType().resolveBinding()) == null || !Collator.getInstance().equals(JAVA_LANG_SECURITY_EXCEPTION, binding.getQualifiedName())) continue;
            resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)cc);
        }
    }
}

