/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.security.j2ee.quickfix;

import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class RemoveMethodInvocationQuickFix
extends JavaCodeReviewQuickFix {
    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        MethodInvocation mi = (MethodInvocation)theNode;
        if (mi != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)mi);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            ListRewrite lr = rewriter.getListRewrite((ASTNode)this.getBlock((ASTNode)mi), Block.STATEMENTS_PROPERTY);
            lr.remove((ASTNode)this.getSt((ASTNode)mi), null);
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    private Block getBlock(ASTNode node) {
        Block tempBlk = null;
        ASTNode tempNode = node;
        while (tempBlk == null) {
            if (tempNode.getParent() instanceof Block) {
                tempBlk = (Block)tempNode.getParent();
            }
            tempNode = tempNode.getParent();
        }
        return tempBlk;
    }

    private Statement getSt(ASTNode node) {
        Statement tempSt = null;
        ASTNode tempNode = node;
        while (tempSt == null) {
            if (node.getParent() instanceof Statement) {
                tempSt = (Statement)node.getParent();
            }
            tempNode = tempNode.getParent();
        }
        return tempSt;
    }
}

