/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.security.j2ee;

import com.ibm.icu.text.NumberFormat;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.logging.Log;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.text.ParseException;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class PrivilegedBlockLimitRule
extends AbstractAnalysisRule {
    private static final String LINES_VARIABLE = "LINESVARIABLE";
    private static final String PRIVILEGED_ACTION_CLASS = "java.security.PrivilegedAction";
    private static final String PRIVILEGED_EXCEPTION_ACTION_CLASS = "java.security.PrivilegedExceptionAction";
    private static final String RUN_METHOD = "run";

    public void analyze(AnalysisHistory history) {
        String historyId = history.getHistoryId();
        CodeReviewResource resource = (CodeReviewResource)this.getProvider().getProperty(historyId, "codereview.java.resource");
        CompilationUnit cu = resource.getResourceCompUnit();
        int lines = 5;
        if (this.getParameter(LINES_VARIABLE) != null) {
            try {
                lines = NumberFormat.getNumberInstance().parse(this.getParameter(LINES_VARIABLE).getValue()).intValue();
            }
            catch (ParseException e) {
                Log.severe((String)"", (Throwable)e);
            }
        }
        List tds = resource.getTypedNodeList((ASTNode)cu, 55);
        for (TypeDeclaration td : tds) {
            ITypeBinding type = td.resolveBinding();
            if (!ASTHelper.instanceOf((ITypeBinding)type, (String)PRIVILEGED_ACTION_CLASS) && !ASTHelper.instanceOf((ITypeBinding)type, (String)PRIVILEGED_EXCEPTION_ACTION_CLASS)) continue;
            MethodDeclaration[] mds = td.getMethods();
            int j = 0;
            while (j < mds.length) {
                if (RUN_METHOD.equals(mds[j].getName().getIdentifier()) && mds[j].parameters().size() == 0 && ASTHelper.getLineCount((ASTNode)mds[j]) > lines) {
                    resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)mds[j]);
                }
                ++j;
            }
        }
        List acds = resource.getTypedNodeList((ASTNode)cu, 1);
        for (AnonymousClassDeclaration acd : acds) {
            ITypeBinding type = acd.resolveBinding();
            if (!ASTHelper.instanceOf((ITypeBinding)type, (String)PRIVILEGED_ACTION_CLASS) && !ASTHelper.instanceOf((ITypeBinding)type, (String)PRIVILEGED_EXCEPTION_ACTION_CLASS)) continue;
            List bds = acd.bodyDeclarations();
            for (BodyDeclaration bd : bds) {
                MethodDeclaration md;
                if (bd.getNodeType() != 31 || !RUN_METHOD.equals((md = (MethodDeclaration)bd).getName().getIdentifier()) || md.parameters().size() != 0 || ASTHelper.getLineCount((ASTNode)md) <= lines) continue;
                resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)md);
            }
        }
    }
}

