/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.performance.speed.quickfix;

import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class RulePerformanceUnncessaryEqualityQuickFix
extends JavaCodeReviewQuickFix {
    private static final String BANG = "!";
    private InfixExpression inf = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        this.inf = null;
        if (theNode instanceof InfixExpression) {
            this.inf = (InfixExpression)theNode;
        }
        if (this.inf != null) {
            boolean boolResult;
            Expression nodeToKeep;
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)this.inf);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            Expression rhs = ASTHelper.removeParenthesis((Expression)this.inf.getRightOperand());
            Expression lhs = ASTHelper.removeParenthesis((Expression)this.inf.getLeftOperand());
            if (rhs != null && rhs.getNodeType() == 9) {
                nodeToKeep = this.inf.getLeftOperand();
                boolResult = this.getBooleanResult((BooleanLiteral)rhs, this.inf);
            } else {
                nodeToKeep = this.inf.getRightOperand();
                boolResult = this.getBooleanResult((BooleanLiteral)lhs, this.inf);
            }
            if (this.hasUnnecessaryParentheses(nodeToKeep, this.inf)) {
                ParenthesizedExpression parenthesizedExpr = (ParenthesizedExpression)nodeToKeep;
                nodeToKeep = parenthesizedExpr.getExpression();
            }
            ASTNode replace = null;
            if (boolResult) {
                replace = rewriter.createCopyTarget((ASTNode)nodeToKeep);
                rewriter.replace((ASTNode)this.inf, replace, null);
            } else {
                StringBuffer sb = new StringBuffer(BANG).append(nodeToKeep.toString());
                replace = rewriter.createStringPlaceholder(sb.toString(), 38);
                rewriter.replace((ASTNode)this.inf, replace, null);
            }
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    private boolean isEqualsTrue(BooleanLiteral boolLiteral, InfixExpression inf1) {
        return InfixExpression.Operator.EQUALS.equals(inf1.getOperator()) && boolLiteral.booleanValue();
    }

    private boolean isNotEqualsFalse(BooleanLiteral boolLiteral, InfixExpression inf1) {
        return InfixExpression.Operator.NOT_EQUALS.equals(inf1.getOperator()) && !boolLiteral.booleanValue();
    }

    private boolean getBooleanResult(BooleanLiteral boolLiteral, InfixExpression inf1) {
        return this.isEqualsTrue(boolLiteral, inf1) || this.isNotEqualsFalse(boolLiteral, inf1);
    }

    private boolean hasUnnecessaryParentheses(Expression operand, InfixExpression inf1) {
        ASTNode parentCond = inf1.getParent();
        return operand.getNodeType() == 36 && parentCond.getNodeType() != 27 && parentCond.getNodeType() != 38 && parentCond.getNodeType() != 37;
    }
}

