/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.performance.speed;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;

public class RulePerformanceCollectionsWithSize
extends AbstractAnalysisRule {
    private static final String CLASSTYPE = "java.util.Collection";
    private static final String INT = "int";

    public void analyze(AnalysisHistory history) {
        CodeReviewResource resource = (CodeReviewResource)this.getProvider().getProperty(history.getHistoryId(), "codereview.java.resource");
        List list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 14);
        for (ClassInstanceCreation cic : list) {
            ITypeBinding binding = cic.resolveTypeBinding();
            if (binding == null || cic.arguments().size() != 0 || !ASTHelper.instanceOf((ITypeBinding)binding, (String)CLASSTYPE) || !this.hasPublicConstructorWithType(binding, INT)) continue;
            resource.generateResultsForASTNode((AbstractAnalysisRule)this, history.getHistoryId(), (ASTNode)cic);
        }
    }

    private boolean hasPublicConstructorWithType(ITypeBinding binding, String type) {
        IMethodBinding[] bindings = binding.getDeclaredMethods();
        int index = 0;
        while (index < bindings.length) {
            if (bindings[index].isConstructor() && bindings[index].getParameterTypes().length == 1 && Modifier.isPublic((int)bindings[index].getModifiers()) && Collator.getInstance().equals(bindings[index].getParameterTypes()[0].getQualifiedName(), type)) {
                return true;
            }
            ++index;
        }
        return false;
    }
}

