/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.performance.profiling;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;

public class RulePerformanceSystemOurErr
extends AbstractAnalysisRule {
    private static final String SYSTEMOUTCLASS = "System.out";
    private static final String SYSTEMERRCLASS = "System.err";
    private static final String PRINTSTREAM = "java.io.PrintStream";

    public void analyze(AnalysisHistory history) {
        CodeReviewResource resource = (CodeReviewResource)this.getProvider().getProperty(history.getHistoryId(), "codereview.java.resource");
        List list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 32);
        for (MethodInvocation mi : list) {
            List expList = ASTHelper.getExpressionList((ASTNode)mi);
            for (Expression exp : expList) {
                if (exp.getNodeType() != 40) continue;
                String methodName = ((QualifiedName)exp).getFullyQualifiedName();
                String expString = ASTHelper.getDataType((ASTNode)exp);
                if (methodName == null || expString == null || !Collator.getInstance().equals(PRINTSTREAM, expString) || !Collator.getInstance().equals(SYSTEMOUTCLASS, methodName) && !Collator.getInstance().equals(SYSTEMERRCLASS, methodName)) continue;
                resource.generateResultsForASTNode((AbstractAnalysisRule)this, history.getHistoryId(), (ASTNode)mi);
            }
        }
    }
}

