/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.performance.memory.quickfix;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class RulePerformancePrimitiveTypeTemporariesQuickFix
extends JavaCodeReviewQuickFix {
    private static final String FIX1 = "%1%.toString( %2% ) )";
    private static final String FIX2 = "%1%.valueOf(  %2% ).toString()";
    private static final String TAG_1 = "%1%";
    private static final String TAG_2 = "%2%";
    public static final String STRING = "java.lang.String";
    public static final String CHARACTER = "java.lang.Character";
    private MethodInvocation mi = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        this.mi = null;
        if (theNode instanceof MethodInvocation) {
            this.mi = (MethodInvocation)theNode;
        }
        if (this.mi != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)this.mi);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            Expression exp = ASTHelper.removeParenthesis((Expression)this.mi.getExpression());
            if (exp != null && exp instanceof ClassInstanceCreation) {
                ClassInstanceCreation cic = (ClassInstanceCreation)exp;
                String arg = cic.arguments().get(0).toString();
                Type cicType = cic.getType();
                ASTNode replace = null;
                ITypeBinding typeBinding = cicType.resolveBinding();
                if (typeBinding != null) {
                    String line;
                    if (Collator.getInstance().equals(STRING, typeBinding.getQualifiedName())) {
                        replace = rewriter.createStringPlaceholder(arg, 45);
                    } else if (Collator.getInstance().equals(CHARACTER, typeBinding.getQualifiedName())) {
                        line = AnalysisCorePlugin.replace((String)FIX1, (String)TAG_1, (String)typeBinding.getName());
                        line = AnalysisCorePlugin.replace((String)line, (String)TAG_2, (String)arg);
                        replace = rewriter.createStringPlaceholder(line, 32);
                    } else {
                        line = AnalysisCorePlugin.replace((String)FIX2, (String)TAG_1, (String)typeBinding.getName());
                        line = AnalysisCorePlugin.replace((String)line, (String)TAG_2, (String)arg);
                        replace = rewriter.createStringPlaceholder(line, 32);
                    }
                    rewriter.replace((ASTNode)this.mi, replace, null);
                    MultiTextEdit edits = new MultiTextEdit();
                    edits.addChild(rewriter.rewriteAST(docToChange, null));
                    return edits;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }
}

