/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.designprinciples.complexity;

import com.ibm.icu.text.NumberFormat;
import com.ibm.rsaz.analysis.codereview.java.AbstractCodeReviewRule;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.logging.Log;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.text.ParseException;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.TryStatement;

public class RuleNestedTry
extends AbstractCodeReviewRule {
    private static final String DEPTHVARIABLE = "DEPTHVARIABLE";
    private int maxDepth;

    public void analyze(AnalysisHistory history, CodeReviewResource resource) {
        try {
            this.maxDepth = NumberFormat.getNumberInstance().parse(this.getParameter(DEPTHVARIABLE).getValue()).intValue();
            List list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 55);
            this.findMatchExpression(history.getHistoryId(), resource, list);
            list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 1);
            this.findMatchExpression(history.getHistoryId(), resource, list);
        }
        catch (ParseException e) {
            Log.severe((String)"", (Throwable)e);
        }
    }

    private void findMatchExpression(String historyId, CodeReviewResource resource, List list) {
        for (ASTNode td : list) {
            List tryList = resource.getTypedNodeList(td, 54);
            for (TryStatement stmt : tryList) {
                if (ASTHelper.levelNest((ASTNode)stmt, (ASTNode)td) <= this.maxDepth) continue;
                resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)stmt);
            }
        }
    }
}

