/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.translation.util;

import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.StringSearch;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.LineComment;

public class NLSUtil {
    private static final String NON_NLS_STRING = "$NON-NLS";

    private NLSUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean doesNodeHaveNonNLSComment(ICompilationUnit compilationUnit, ASTNode node) {
        try {
            CompilationUnit root = (CompilationUnit)node.getRoot();
            List comments = root.getCommentList();
            int nodeStartLine = root.getLineNumber(node.getStartPosition());
            int nodeEndLine = root.getLineNumber(node.getStartPosition() + node.getLength());
            Iterator i = comments.iterator();
            while (true) {
                LineComment lineComment;
                int commentLine;
                if (!i.hasNext()) {
                    return false;
                }
                Comment comment = (Comment)i.next();
                if (comment.getNodeType() != 63 || (commentLine = root.getLineNumber((lineComment = (LineComment)comment).getStartPosition())) < nodeStartLine) continue;
                if (commentLine > nodeEndLine) {
                    return false;
                }
                String commentText = compilationUnit.getBuffer().getText(lineComment.getStartPosition(), lineComment.getLength());
                RuleBasedCollator collator = (RuleBasedCollator)RuleBasedCollator.getInstance();
                collator.setStrength(0);
                StringSearch search = new StringSearch(String.valueOf(NON_NLS_STRING), (CharacterIterator)new StringCharacterIterator(commentText), collator);
                if (search.first() > 0) break;
            }
            return true;
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }
}

