/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.stringhandling.quickfix;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class ToLowerOrUpperCaseQuickFix
extends JavaCodeReviewQuickFix {
    public static final String IMPORT = "com.ibm.icu.lang.UCharacter";
    public static final String CLASS_CHARACTER = "java.lang.Character";
    public static final String CLASS_STRING = "java.lang.String";
    public static final String METHOD_TO_LOWER = "toLowerCase";
    public static final String METHOD_TO_UPPER = "toUpperCase";
    private static final String IMPORTLINE = "import %imp%;";
    private static final String IMPORT_TAG = "%imp%";
    private static final String FIX1 = "UCharacter.%1%( %2% )";
    private static final String FIX2 = "UCharacter.%1%( %2%, %3% )";
    private static final String TAG_1 = "%1%";
    private static final String TAG_2 = "%2%";
    private static final String TAG_3 = "%3%";
    private String theClass = null;
    private String methodName = null;
    private MethodInvocation mi = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        this.mi = null;
        if (theNode instanceof MethodInvocation) {
            this.mi = (MethodInvocation)theNode;
        }
        if (this.mi != null) {
            String line;
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)this.mi);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            CompilationUnit rootNode = (CompilationUnit)this.mi.getRoot();
            ChildListPropertyDescriptor descriptor = CompilationUnit.IMPORTS_PROPERTY;
            ListRewrite lr = rewriter.getListRewrite((ASTNode)rootNode, descriptor);
            List imports = rootNode.imports();
            boolean addImport = true;
            for (ImportDeclaration ip : imports) {
                if (!Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), IMPORT)) continue;
                addImport = false;
                break;
            }
            if (addImport) {
                String line2 = AnalysisCorePlugin.replace((String)IMPORTLINE, (String)IMPORT_TAG, (String)IMPORT);
                ASTNode newImport = rewriter.createStringPlaceholder(line2, 26);
                lr.insertLast(newImport, null);
            }
            String argument = null;
            String argument2 = null;
            ASTNode replaceNode = null;
            if (Collator.getInstance().equals(this.theClass, CLASS_CHARACTER)) {
                argument = this.mi.arguments().get(0).toString();
                line = AnalysisCorePlugin.replace((String)FIX1, (String)TAG_1, (String)this.methodName);
                line = AnalysisCorePlugin.replace((String)line, (String)TAG_2, (String)argument);
                replaceNode = rewriter.createStringPlaceholder(line, 32);
                rewriter.replace((ASTNode)this.mi, replaceNode, null);
            } else if (Collator.getInstance().equals(this.theClass, CLASS_STRING)) {
                if (this.mi.arguments().size() == 0) {
                    line = AnalysisCorePlugin.replace((String)FIX1, (String)TAG_1, (String)this.methodName);
                    line = AnalysisCorePlugin.replace((String)line, (String)TAG_2, (String)argument);
                    replaceNode = rewriter.createStringPlaceholder(line, 32);
                } else if (this.mi.arguments().size() == 1) {
                    argument = this.mi.arguments().get(0).toString();
                    argument2 = this.mi.getExpression().toString();
                    line = AnalysisCorePlugin.replace((String)FIX2, (String)TAG_1, (String)this.methodName);
                    line = AnalysisCorePlugin.replace((String)line, (String)TAG_2, (String)argument);
                    line = AnalysisCorePlugin.replace((String)line, (String)TAG_3, (String)argument2);
                    replaceNode = rewriter.createStringPlaceholder(line, 32);
                }
            }
            if (replaceNode == null) {
                return null;
            }
            rewriter.replace((ASTNode)this.mi, replaceNode, null);
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    public String getTheClass() {
        return this.theClass;
    }

    public void setTheClass(String theClass) {
        this.theClass = theClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }
}

