/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.stringhandling.quickfix;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StringValueOfQuickFix
extends JavaCodeReviewQuickFix {
    public static final String IMPORT_IBM_ICU_NUMBER_FORMAT = "com.ibm.icu.text.NumberFormat";
    public static final String IMPORT_JAVA_TEXT_NUMBER_FORMAT = "java.text.NumberFormat";
    private static final String IMPORT = "import %imp%;";
    private static final String IMPORT_TAG = "%imp%";
    private static final String FIX1 = "NumberFormat.getNumberInstance().format( %1% )";
    private static final String TAG_1 = "%1%";
    private String theImport = null;
    private MethodInvocation mi = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        this.mi = null;
        if (theNode instanceof MethodInvocation) {
            this.mi = (MethodInvocation)theNode;
        }
        if (this.mi != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)this.mi);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            CompilationUnit rootNode = (CompilationUnit)this.mi.getRoot();
            ChildListPropertyDescriptor descriptor = CompilationUnit.IMPORTS_PROPERTY;
            ListRewrite lr = rewriter.getListRewrite((ASTNode)rootNode, descriptor);
            List imports = rootNode.imports();
            boolean addImport = true;
            for (ImportDeclaration ip : imports) {
                if (!Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), this.theImport)) continue;
                addImport = false;
                break;
            }
            if (addImport) {
                String line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)this.theImport);
                ASTNode newImport = rewriter.createStringPlaceholder(line, 26);
                lr.insertLast(newImport, null);
            }
            String argument = this.mi.arguments().get(0).toString();
            String line = AnalysisCorePlugin.replace((String)FIX1, (String)TAG_1, (String)argument);
            ASTNode replaceNode = rewriter.createStringPlaceholder(line, 32);
            rewriter.replace((ASTNode)this.mi, replaceNode, null);
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    public String getTheImport() {
        return this.theImport;
    }

    public void setTheImport(String theImport) {
        this.theImport = theImport;
    }
}

