/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.stringhandling.quickfix;

import com.ibm.xtools.analysis.codereview.java.globalization.translation.util.GlobalizationQuickFix;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StringIndexOfQuickFix
extends GlobalizationQuickFix {
    public static final String INT = "int";
    public static final String RULE_BASED_COLLATOR = "com.ibm.icu.text.RuleBasedCollator";
    public static final String STRING_SEARCH = "com.ibm.icu.text.StringSearch";
    public static final String STRING_CHARACTER_ITERATOR = "java.text.StringCharacterIterator";
    private static final String IMPORT = "import {0};";
    private static final String FIX1 = "int {0} = -1;";
    private static final String FIX2 = "if ({0}.length() != 0) {";
    private static final String FIX3 = "\tfinal RuleBasedCollator {0} = (RuleBasedCollator)RuleBasedCollator.getInstance();";
    private static final String FIX4 = "\t{0}.setStrength( RuleBasedCollator.PRIMARY );";
    private static final String FIX5 = "\tfinal StringSearch {0} = new StringSearch(String.valueOf( {1} ), new StringCharacterIterator( {2} ), {3} );";
    private static final String FIX6 = "\t{0}.setIndex( {1} );";
    private static final String FIX7 = "{0}.first()";
    private static final String FIX8 = "{0}.next()";
    private static final String FIX9 = "\t{0} = {1};\n}";

    public TextEdit fixCodeReviewResult(ASTNode node, IDocument docToChange) {
        ASTNode newId;
        String replaceString;
        if (node == null || node.getNodeType() != 32) {
            return null;
        }
        MethodInvocation mi = (MethodInvocation)node;
        ASTNode enclosingClass = this.getEnclosingClass((ASTNode)mi);
        AST ast = enclosingClass.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        CompilationUnit root = (CompilationUnit)mi.getRoot();
        ChildListPropertyDescriptor descriptor = CompilationUnit.IMPORTS_PROPERTY;
        ListRewrite lr = rewriter.getListRewrite((ASTNode)root, descriptor);
        List imports = root.imports();
        boolean hasRuleBased = false;
        boolean hasStringSerach = false;
        boolean hasStringCharIter = false;
        for (ImportDeclaration importDeclaration : imports) {
            if (!hasRuleBased && RULE_BASED_COLLATOR.equals(importDeclaration.getName().getFullyQualifiedName())) {
                hasRuleBased = true;
            }
            if (!hasStringSerach && STRING_SEARCH.equals(importDeclaration.getName().getFullyQualifiedName())) {
                hasStringSerach = true;
            }
            if (!hasStringCharIter && STRING_CHARACTER_ITERATOR.equals(importDeclaration.getName().getFullyQualifiedName())) {
                hasStringCharIter = true;
            }
            if (hasRuleBased && hasStringSerach && hasStringCharIter) break;
        }
        if (!hasStringCharIter) {
            replaceString = NLS.bind((String)IMPORT, (Object)STRING_CHARACTER_ITERATOR);
            newId = rewriter.createStringPlaceholder(replaceString, 26);
            lr.insertLast(newId, null);
        }
        if (!hasRuleBased) {
            replaceString = NLS.bind((String)IMPORT, (Object)RULE_BASED_COLLATOR);
            newId = rewriter.createStringPlaceholder(replaceString, 26);
            lr.insertLast(newId, null);
        }
        if (!hasStringSerach) {
            replaceString = NLS.bind((String)IMPORT, (Object)STRING_SEARCH);
            newId = rewriter.createStringPlaceholder(replaceString, 26);
            lr.insertLast(newId, null);
        }
        String resultVarName = this.getUniqueIdentifierName(this.getWorkingCompilationUnit(), (ASTNode)mi, INT);
        String line = NLS.bind((String)FIX1, (Object)resultVarName);
        ASTNode resultVariableDeclaration = rewriter.createStringPlaceholder(line, 60);
        this.insertNode(mi, rewriter, resultVariableDeclaration);
        String arg2 = mi.getExpression().toString();
        line = NLS.bind((String)FIX2, (Object)arg2);
        ASTNode ifStatement = rewriter.createStringPlaceholder(line, 25);
        this.insertNode(mi, rewriter, ifStatement);
        String varName = this.getUniqueIdentifierName(this.getWorkingCompilationUnit(), (ASTNode)mi, RULE_BASED_COLLATOR);
        line = NLS.bind((String)FIX3, (Object)varName);
        ASTNode collatorNode = rewriter.createStringPlaceholder(line, 60);
        this.insertNode(mi, rewriter, collatorNode);
        line = NLS.bind((String)FIX4, (Object)varName);
        ASTNode setStrengthNode = rewriter.createStringPlaceholder(line, 32);
        this.insertNode(mi, rewriter, setStrengthNode);
        String varName2 = this.getUniqueIdentifierName(this.getWorkingCompilationUnit(), (ASTNode)mi, STRING_SEARCH);
        String arg1 = mi.arguments().get(0).toString();
        line = NLS.bind((String)FIX5, (Object[])new Object[]{varName2, arg1, arg2, varName});
        ASTNode searchNode = rewriter.createStringPlaceholder(line, 60);
        this.insertNode(mi, rewriter, searchNode);
        if (mi.arguments().size() == 2) {
            String arg3 = mi.arguments().get(1).toString();
            line = NLS.bind((String)FIX6, (Object)varName2, (Object)arg3);
            ASTNode setIndexNode = rewriter.createStringPlaceholder(line, 32);
            this.insertNode(mi, rewriter, setIndexNode);
            line = NLS.bind((String)FIX8, (Object)varName2);
        } else {
            line = NLS.bind((String)FIX7, (Object)varName2);
        }
        String line2 = NLS.bind((String)FIX9, (Object)resultVarName, (Object)line);
        ASTNode assignment = rewriter.createStringPlaceholder(line2, 7);
        this.insertNode(mi, rewriter, assignment);
        ASTNode firstNode = rewriter.createStringPlaceholder(resultVarName, 42);
        rewriter.replace((ASTNode)mi, firstNode, null);
        MultiTextEdit edits = new MultiTextEdit();
        edits.addChild(rewriter.rewriteAST(docToChange, null));
        return edits;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    private ASTNode getNodeBetween(ASTNode beginNode, ASTNode endNode, int nodeTypeToFind) {
        ASTNode node = beginNode;
        while (node != null && node.equals((Object)endNode)) {
            if (node.getNodeType() == nodeTypeToFind) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private Statement getFirstEnclosingStatement(ASTNode node) {
        ASTNode beginNode = node;
        while (beginNode != null && beginNode.getNodeType() != 31 && beginNode.getNodeType() != 55 && beginNode.getNodeType() != 1) {
            if (beginNode instanceof Statement) {
                return (Statement)beginNode;
            }
            beginNode = beginNode.getParent();
        }
        return null;
    }

    private void processInsertWithLabel(ASTRewrite r, ListRewrite l, Block block, LabeledStatement labeledStatement) {
        ASTNode placeHolderNode = r.createMoveTarget((ASTNode)labeledStatement.getBody());
        l.insertAfter(placeHolderNode, (ASTNode)labeledStatement, null);
    }

    private void insertNode(MethodInvocation m, ASTRewrite r, ASTNode astNode) {
        Block block = this.getBlock((ASTNode)m);
        if (block != null) {
            ASTNode node = this.getNodeBetween((ASTNode)m, (ASTNode)block, 30);
            ListRewrite l = r.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
            if (node != null) {
                this.processInsertWithLabel(r, l, block, (LabeledStatement)node);
            } else {
                Statement ref = this.getFirstEnclosingStatement((ASTNode)m);
                l.insertBefore(astNode, (ASTNode)ref, null);
            }
        }
    }
}

