/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.stringhandling.quickfix;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StringCharAtQuickFix
extends JavaCodeReviewQuickFix {
    public static final String IMPORT_UCHARACTER = "com.ibm.icu.lang.UCharacter";
    public static final String IMPORT_UTF16 = "com.ibm.icu.text.UTF16";
    public static final String CLASS_UCHARACTER = "UCharacter";
    public static final String CLASS_UTF16 = "UTF16";
    public static final String METHOD_UCHARACTER_CODEPOINTAT = "codePointAt";
    public static final String METHOD_UTF16_CHARAT = "charAt";
    private static final String IMPORT = "import %imp%;";
    private static final String IMPORT_TAG = "%imp%";
    private static final String FIX1 = "%1%.%2%( %3%, %4%)";
    private static final String TAG_1 = "%1%";
    private static final String TAG_2 = "%2%";
    private static final String TAG_3 = "%3%";
    private static final String TAG_4 = "%4%";
    private String theImport = null;
    private String theClass = null;
    private String theMethod = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        MethodInvocation mi = (MethodInvocation)theNode;
        if (mi != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)mi);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            CompilationUnit rootNode = (CompilationUnit)mi.getRoot();
            ChildListPropertyDescriptor descriptor = CompilationUnit.IMPORTS_PROPERTY;
            ListRewrite lr = rewriter.getListRewrite((ASTNode)rootNode, descriptor);
            List imports = rootNode.imports();
            boolean addImport = true;
            for (ImportDeclaration ip : imports) {
                if (!Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), IMPORT_UCHARACTER)) continue;
                addImport = false;
                break;
            }
            if (addImport) {
                String line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)this.theImport);
                ASTNode newImport = rewriter.createStringPlaceholder(line, 26);
                lr.insertLast(newImport, null);
            }
            String arg1 = mi.getExpression().toString();
            String arg2 = mi.arguments().get(0).toString();
            String line = AnalysisCorePlugin.replace((String)FIX1, (String)TAG_1, (String)this.theClass);
            line = AnalysisCorePlugin.replace((String)line, (String)TAG_2, (String)this.theMethod);
            line = AnalysisCorePlugin.replace((String)line, (String)TAG_3, (String)arg1);
            line = AnalysisCorePlugin.replace((String)line, (String)TAG_4, (String)arg2);
            ASTNode replaceNode = rewriter.createStringPlaceholder(line, 32);
            rewriter.replace((ASTNode)mi, replaceNode, null);
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    public String getTheClass() {
        return this.theClass;
    }

    public void setTheClass(String theClass) {
        this.theClass = theClass;
    }

    public String getTheImport() {
        return this.theImport;
    }

    public void setTheImport(String theImport) {
        this.theImport = theImport;
    }

    public String getTheMethod() {
        return this.theMethod;
    }

    public void setTheMethod(String theMethod) {
        this.theMethod = theMethod;
    }
}

