/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.subclipse.ui.internal;

import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.svn.common.SvnBugtraqProperties;
import com.ibm.team.scm.svn.common.SvnLogEntry;
import com.ibm.team.scm.svn.subclipse.ui.internal.SubclipseMessages;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SubclipseLogEntry
extends SvnLogEntry {
    private final ILogEntry entry;

    public static ProjectProperties getProjectProperties(ILogEntry log) throws TeamRepositoryException {
        IResource localResource;
        ProjectProperties properties = null;
        ISVNResource resource = log.getResource();
        if (resource != null && (localResource = resource.getResource()) != null) {
            try {
                properties = ProjectProperties.getProjectProperties((IResource)localResource);
            }
            catch (SVNException e) {
                throw new TeamRepositoryException(NLS.bind((String)SubclipseMessages.SubclipseLogEntry_0, (Object)localResource.getProject().getName()), (Throwable)e);
            }
        }
        return properties;
    }

    public static ILogEntry asLogEntry(Object revision) {
        if (revision instanceof ILogEntry) {
            return (ILogEntry)revision;
        }
        if (revision instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)revision;
            return (ILogEntry)adaptable.getAdapter(ILogEntry.class);
        }
        return null;
    }

    public static SubclipseLogEntry createFor(Object selectedEntry) {
        ILogEntry entry = SubclipseLogEntry.asLogEntry(selectedEntry);
        return new SubclipseLogEntry(entry);
    }

    public SubclipseLogEntry(ILogEntry entry) {
        this.entry = entry;
    }

    public IURIReference asUriReference() throws URISyntaxException {
        String comment = this.entry.getComment();
        String revisionString = this.entry.getRevision().toString();
        URI uri = this.convertToUri(this.entry);
        return SubclipseLogEntry.createReference((URI)uri, (String)comment, (String)revisionString);
    }

    public URI convertToUri(ILogEntry entry) throws URISyntaxException {
        SVNRevision.Number rev = entry.getRevision();
        ISVNResource resource = entry.getResource();
        ISVNRepositoryLocation repository = resource.getRepository();
        SVNUrl repositoryRoot = repository.getRepositoryRoot();
        return this.createURI(repositoryRoot, rev);
    }

    private URI createURI(SVNUrl repositoryRoot, SVNRevision.Number rev) throws URISyntaxException {
        int port = repositoryRoot.getPort();
        String protocol = repositoryRoot.getProtocol();
        if (SVNUrl.getDefaultPort((String)protocol) == port) {
            port = -1;
        }
        String host = repositoryRoot.getHost();
        String path = SubclipseLogEntry.toString(repositoryRoot.getPathSegments());
        String revisionString = Long.toString(rev.getNumber());
        return SubclipseLogEntry.createURI((String)protocol, null, (String)host, (int)port, (String)path, (String)revisionString);
    }

    private static String toString(String[] pathSegments) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < pathSegments.length) {
            String string = pathSegments[i];
            result.append("/");
            result.append(string);
            ++i;
        }
        return result.toString();
    }

    public String getRepositoryUrl() {
        ISVNResource resource = this.entry.getResource();
        ISVNRepositoryLocation repository = resource.getRepository();
        SVNUrl repositoryRoot = repository.getRepositoryRoot();
        return repositoryRoot.toString();
    }

    public SvnBugtraqProperties getBugtraqProperties() throws TeamRepositoryException {
        ProjectProperties properties = SubclipseLogEntry.getProjectProperties(this.entry);
        return SubclipseLogEntry.asBugtraqProperties(properties);
    }

    public static SvnBugtraqProperties asBugtraqProperties(ProjectProperties properties) {
        SvnBugtraqProperties bp = new SvnBugtraqProperties();
        if (properties != null) {
            bp.put("bugtraq:url", properties.getUrl());
            bp.put("bugtraq:label", properties.getLabel());
            bp.put("bugtraq:message", properties.getMessage());
            bp.put("bugtraq:number", Boolean.toString(properties.isNumber()));
            bp.put("bugtraq:append", Boolean.toString(properties.isAppend()));
            bp.put("bugtraq:warnifnoissue", Boolean.toString(properties.isWarnIfNoIssue()));
        }
        return bp;
    }

    public String getComment() {
        return this.entry.getComment();
    }

    public ISVNResource getResource() {
        return this.entry.getResource();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            return this.getResource().getResource();
        }
        return super.getAdapter(adapter);
    }

    public long getRevision() {
        return this.entry.getRevision().getNumber();
    }
}

