/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.subclipse.ui.internal;

import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.importz.internal.utils.PathUtils;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNImportOperation;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.tigris.subversion.subclipse.core.ISVNFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;

public class SubclipseImportAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        ISVNRepositoryLocation repository = this.getRepository(selection);
        String repositoryUrl = repository.getLocation();
        String[] folderPaths = new String[selection.size()];
        int i = 0;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            folderPaths[i++] = ((ISVNRemoteFolder)iter.next()).getRepositoryRelativePath();
        }
        SVNImportOperation.importFromSVN((UIContext)this.getContext(), (String)repositoryUrl, (String[])folderPaths);
    }

    private ISVNRepositoryLocation getRepository(IStructuredSelection selection) {
        return ((ISVNRemoteFolder)selection.getFirstElement()).getRepository();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            Object[] elements = ((IStructuredSelection)selection).toArray();
            ISVNRepositoryLocation repository = null;
            int i = 0;
            while (i < elements.length) {
                if (!(elements[i] instanceof ISVNRemoteFolder)) {
                    action.setEnabled(false);
                    return;
                }
                ISVNFolder folder = (ISVNFolder)elements[i];
                if (repository == null) {
                    repository = folder.getRepository();
                } else if (!repository.equals(folder.getRepository())) {
                    action.setEnabled(false);
                    return;
                }
                if (this.hasOverlap(folder, i + 1, elements)) {
                    action.setEnabled(false);
                    return;
                }
                ++i;
            }
            action.setEnabled(true);
        }
    }

    private boolean hasOverlap(ISVNFolder folder, int offset, Object[] elements) {
        int i = offset;
        while (i < elements.length) {
            ISVNRemoteFolder other;
            Object object = elements[i];
            if (object instanceof ISVNRemoteFolder && (PathUtils.isParentUrl((String)(other = (ISVNRemoteFolder)object).getUrl().toString(), (String)folder.getUrl().toString()) || PathUtils.isParentUrl((String)folder.getUrl().toString(), (String)other.getUrl().toString()))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

