/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.importz.svn.internal.Activator;
import com.ibm.team.scm.svn.common.SVNWorkItemExtractor;
import com.ibm.team.scm.svn.common.SvnBugtraqProperties;
import com.ibm.team.scm.svn.common.SvnLogEntry;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SVNWorkItemAdapter {
    public abstract SvnLogEntry asLogEntry(Object var1);

    public final IURIReference getSelectedRevisionReference(Object revision) {
        SvnLogEntry entry = this.asLogEntry(revision);
        if (entry != null) {
            try {
                return entry.asUriReference();
            }
            catch (URISyntaxException e) {
                this.logException(e);
            }
        }
        return null;
    }

    public final String getRepositoryUrl(Object revision) {
        SvnLogEntry entry = this.asLogEntry(revision);
        if (entry != null) {
            return entry.getRepositoryUrl();
        }
        return null;
    }

    public final ITeamRepository getTeamRepository(Object revision) throws FileSystemClientException, TeamRepositoryException {
        String url;
        SvnLogEntry log = this.asLogEntry(revision);
        SvnBugtraqProperties properties = log.getBugtraqProperties();
        if (properties != null && (url = properties.getUrl()) != null && url.length() > 0) {
            return this.getTeamRepository(url, properties.getMessage(), log.getComment());
        }
        return null;
    }

    public final List<IWorkItemHandle> getWorkItems(Object revision, ITeamRepository teamRepository, SVNWorkItemExtractor extractor, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SvnLogEntry log = this.asLogEntry(revision);
        if (log != null) {
            SvnBugtraqProperties properties = log.getBugtraqProperties();
            if (properties == null) {
                properties = new SvnBugtraqProperties();
                properties.setDefaultBugtraqProperties(this.getWorkItemUrl(teamRepository, "%BUGID%"));
            } else if (properties.getUrl() == null) {
                properties.setDefaultBugtraqProperties(this.getWorkItemUrl(teamRepository, "%BUGID%"));
            }
            return this.getWorkItems(properties, log, extractor, monitor);
        }
        return new ArrayList<IWorkItemHandle>();
    }

    private List<IWorkItemHandle> getWorkItems(SvnBugtraqProperties properties, SvnLogEntry log, SVNWorkItemExtractor extractor, IProgressMonitor monitor) throws TeamRepositoryException {
        String url = properties.getUrl();
        if (url == null || url.length() == 0) {
            return new ArrayList<IWorkItemHandle>();
        }
        return this.getWorkItems(extractor, url, properties.getMessage(), log.getComment(), monitor);
    }

    public abstract SvnBugtraqProperties getBugTrackingProperties(IProject var1) throws FileSystemClientException;

    public abstract void setBugTrackingProperties(IProject var1, SvnBugtraqProperties var2) throws FileSystemClientException;

    public abstract void removeBugTrackingProperties(IProject var1) throws FileSystemClientException;

    protected ITeamRepository getTeamRepository(String workItemUrlPattern, String workItemPattern, String comment) throws TeamRepositoryException {
        Set itemLocations = SVNWorkItemExtractor.getInstance().getWorkItemLocations(workItemUrlPattern, workItemPattern, comment, true);
        if (itemLocations.isEmpty()) {
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(1L);
            itemLocations = SVNWorkItemExtractor.getInstance().getWorkItemLocations(workItemUrlPattern, ids);
        }
        Location location = (Location)itemLocations.iterator().next();
        return this.getTeamRepository(location);
    }

    private ITeamRepository getTeamRepository(Location location) {
        String repoUri = location.getRepoUri();
        if (repoUri != null && repoUri.length() > 0) {
            return TeamPlatform.getTeamRepositoryService().getTeamRepository(repoUri);
        }
        return null;
    }

    public List<IWorkItemHandle> getWorkItems(SVNWorkItemExtractor extractor, String workItemUrlPattern, String bugTraqMessage, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
        List itemNumbers = extractor.extractWorkItemNumbers(bugTraqMessage, comment, true);
        Set itemLocations = extractor.getWorkItemLocations(workItemUrlPattern, itemNumbers);
        return this.resolveWorkItemLocations(itemLocations, monitor);
    }

    public List<IWorkItemHandle> getWorkItems(String workItemUrlPattern, List<Long> ids, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.resolveWorkItemLocations(SVNWorkItemExtractor.getInstance().getWorkItemLocations(workItemUrlPattern, ids), monitor);
    }

    protected final List<IWorkItemHandle> resolveWorkItemLocations(Set<Location> itemLocations, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IWorkItemHandle> result = new ArrayList<IWorkItemHandle>();
        if (itemLocations.size() > 0) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(itemLocations.size() * 100));
            for (Location location : itemLocations) {
                try {
                    IWorkItemHandle handle = this.resolveWorkItem(location, (IProgressMonitor)progress.newChild(100));
                    if (handle == null) continue;
                    result.add(handle);
                }
                catch (ItemNotFoundException itemNotFoundException) {}
            }
        }
        return result;
    }

    private IWorkItemHandle resolveWorkItem(Location location, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = this.getTeamRepository(location);
        IItemManager itemManager = teamRepository.itemManager();
        IItem item = itemManager.fetchCompleteItem(location, 0, monitor);
        if (item instanceof IWorkItemHandle) {
            return (IWorkItemHandle)item;
        }
        return null;
    }

    public void logException(Throwable t) {
        Activator.getDefault().getLog().log(StatusUtil.newStatus((Object)this, (String)t.getMessage(), (Throwable)t));
    }

    public String getWorkItemUrl(ITeamRepository repository, String workItemId) {
        String repositoryURI = repository.getRepositoryURI();
        return SVNWorkItemExtractor.getInstance().getWorkItemUrl(repositoryURI, workItemId);
    }

    public List<URI> getWorkItemUris(IProject project, String text) {
        try {
            SvnBugtraqProperties properties = this.getBugTrackingProperties(project);
            String urlPattern = properties.getUrl();
            String workItemPattern = properties.getMessage();
            if (urlPattern != null && workItemPattern != null) {
                return this.getWorkItemUris(urlPattern, workItemPattern, text);
            }
        }
        catch (FileSystemClientException fileSystemClientException) {
        }
        catch (TeamRepositoryException e) {
            this.logException(e);
        }
        return new ArrayList<URI>();
    }

    private List<URI> getWorkItemUris(String workItemUrlPattern, String workItemPattern, String text) throws TeamRepositoryException {
        Set locations = SVNWorkItemExtractor.getInstance().getWorkItemLocations(workItemUrlPattern, workItemPattern, text, true);
        ArrayList<URI> result = new ArrayList<URI>();
        for (Location location : locations) {
            result.add(location.toAbsoluteUri());
        }
        return result;
    }

    public void setDefaultBugtraqProperties(IProject project, String url) throws FileSystemClientException {
        SvnBugtraqProperties properties = new SvnBugtraqProperties();
        properties.setDefaultBugtraqProperties(url);
        this.setBugTrackingProperties(project, properties);
    }

    public void linkProjectToRepository(Object revision, ITeamRepository teamRepository) throws FileSystemClientException {
        IProject project = this.getProject(revision);
        if (project != null) {
            String workItemUrl = this.getWorkItemUrl(teamRepository, "%BUGID%");
            this.setDefaultBugtraqProperties(project, workItemUrl);
        }
    }

    protected IProject getProject(Object revision) {
        IResource resource;
        SvnLogEntry entry = this.asLogEntry(revision);
        if (entry != null && (resource = (IResource)entry.getAdapter(IResource.class)) != null) {
            return resource.getProject();
        }
        return null;
    }
}

