/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.client.importz.internal.ui.AbstractOptionsArea;
import com.ibm.team.scm.svn.common.SvnBugtraqProperties;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.SVNWorkItemAdapter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BugtraqOptionsArea
extends AbstractOptionsArea {
    private Group repositoryGroup;
    private RepositoryCombo repositoryCombo;
    private SvnBugtraqProperties properties;
    private final SVNWorkItemAdapter workItemAdapter;
    private boolean wasEnabled;
    private final IProject project;
    private Button promptButton;
    private Group appendGroup;
    private Button prependButton;
    private Button appendButton;
    private Group promptGroup;
    private Button connectionButton;

    public BugtraqOptionsArea(Composite parent, IProject project, SVNWorkItemAdapter workItemAdapter, boolean allowBidirectional) {
        this.project = project;
        this.workItemAdapter = workItemAdapter;
        this.repositoryGroup = this.createGroup(parent, SVNRCPMessages.BugtraqOptionsArea_0);
        Label label = new Label((Composite)this.repositoryGroup, 0);
        label.setText(SVNRCPMessages.BugtraqOptionsArea_1);
        this.repositoryCombo = new RepositoryCombo((Composite)this.repositoryGroup, WidgetFactoryContext.forDialogBox());
        if (allowBidirectional) {
            this.connectionButton = new Button((Composite)this.repositoryGroup, 32);
            this.connectionButton.setText(SVNRCPMessages.BugtraqOptionsArea_2);
            this.connectionButton.setToolTipText(SVNRCPMessages.BugtraqOptionsArea_3);
            GridDataFactory.defaultsFor((Control)this.connectionButton).grab(true, false).span(2, 1).applyTo((Control)this.connectionButton);
        }
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)this.repositoryGroup);
        this.appendGroup = this.createGroup(parent, SVNRCPMessages.BugtraqOptionsArea_4);
        this.prependButton = new Button((Composite)this.appendGroup, 16);
        this.prependButton.setText(SVNRCPMessages.BugtraqOptionsArea_5);
        this.appendButton = new Button((Composite)this.appendGroup, 16);
        this.appendButton.setText(SVNRCPMessages.BugtraqOptionsArea_6);
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)this.appendGroup);
        this.promptGroup = this.createGroup(parent, SVNRCPMessages.BugtraqOptionsArea_7);
        this.promptButton = new Button((Composite)this.promptGroup, 32);
        this.promptButton.setText(SVNRCPMessages.BugtraqOptionsArea_8);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)this.promptGroup);
    }

    private Group createGroup(Composite composite, String name) {
        Group group = new Group(composite, 0);
        group.setText(name);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        return group;
    }

    public IObservableValue getValidationStatus() {
        return this.repositoryCombo.getValidationStatus();
    }

    public void initControls() {
        super.initControls();
        try {
            this.properties = this.getWorkItemAdapter().getBugTrackingProperties(this.project);
        }
        catch (FileSystemClientException e) {
            this.getWorkItemAdapter().logException(e);
        }
        boolean enable = false;
        if (this.properties == null) {
            this.properties = new SvnBugtraqProperties();
        } else {
            String message;
            String url = this.properties.getUrl();
            if (url != null && (message = this.properties.getMessage()) != null) {
                try {
                    ITeamRepository teamRepository = this.getWorkItemAdapter().getTeamRepository(url, message, message.replace("%BUGID%", "1"));
                    this.repositoryCombo.setSelectedElement(teamRepository);
                    enable = true;
                    this.wasEnabled = true;
                }
                catch (TeamRepositoryException e) {
                    this.getWorkItemAdapter().logException(e);
                }
            }
            this.promptButton.setSelection(this.properties.getWarnIfNoIssue());
            this.prependButton.setSelection(!this.properties.getAppend());
            this.appendButton.setSelection(this.properties.getAppend());
        }
        this.setEnabled(enable);
    }

    private SVNWorkItemAdapter getWorkItemAdapter() {
        return this.workItemAdapter;
    }

    protected void updateEnablements() {
        this.enableGroup(this.repositoryGroup, this.isEnabled());
        this.enableGroup(this.appendGroup, this.isEnabled());
        this.enableGroup(this.promptGroup, this.isEnabled());
    }

    private String getWorkItemUrl() {
        ITeamRepository repository = this.repositoryCombo.getRepository();
        if (repository == null) {
            return null;
        }
        return this.getWorkItemAdapter().getWorkItemUrl(repository, "%BUGID%");
    }

    public boolean updateProperties() {
        if (this.isEnabled()) {
            String url = this.getWorkItemUrl();
            if (this.project != null && url.length() > 0 && this.hasChange()) {
                this.properties.setDefaultBugtraqProperties(url);
                this.properties.put("bugtraq:warnifnoissue", this.promptButton.getSelection());
                this.properties.put("bugtraq:append", this.appendButton.getSelection());
                try {
                    this.getWorkItemAdapter().setBugTrackingProperties(this.project, this.properties);
                }
                catch (FileSystemClientException e) {
                    ErrorDialog.openError((Shell)this.repositoryGroup.getShell(), null, (String)NLS.bind((String)SVNRCPMessages.BugtraqOptionsArea_10, (Object)this.project.getName()), (IStatus)StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                    return false;
                }
            }
        } else if (this.wasEnabled) {
            try {
                this.getWorkItemAdapter().removeBugTrackingProperties(this.project);
            }
            catch (FileSystemClientException e) {
                ErrorDialog.openError((Shell)this.repositoryGroup.getShell(), null, (String)NLS.bind((String)SVNRCPMessages.BugtraqOptionsArea_11, (Object)this.project.getName()), (IStatus)StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                return false;
            }
        }
        return true;
    }

    private boolean hasChange() {
        String url = this.getWorkItemUrl();
        String oldUrl = this.properties.getUrl();
        if (oldUrl == null || !oldUrl.equals(url)) {
            return true;
        }
        if (this.properties.getWarnIfNoIssue() != this.promptButton.getSelection()) {
            return true;
        }
        return this.properties.getAppend() != this.appendButton.getSelection();
    }

    public ITeamRepository getRepository() {
        return this.repositoryCombo.getRepository();
    }

    public boolean isCreateConnection() {
        return this.connectionButton != null && this.connectionButton.getSelection();
    }
}

