/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.view;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import com.ibm.team.scm.svn.client.ISvnClientLibrary;
import com.ibm.team.scm.svn.client.internal.RepositoryEvent;
import com.ibm.team.scm.svn.common.ISvnRepository;
import com.ibm.team.scm.svn.rcp.ui.internal.ImagePool;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.Utils;
import com.ibm.team.scm.svn.rcp.ui.internal.view.SvnRepositoryWrapper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class SvnLabelProvider
extends ListeningLabelProvider
implements IListener {
    private List<ISvnClientLibrary> libraries = new ArrayList<ISvnClientLibrary>();

    protected void doUpdateLabel(ViewerLabel label, Object element) {
        if (element instanceof SvnRepositoryWrapper) {
            element = ((SvnRepositoryWrapper)((Object)element)).getModelInstance();
        }
        if (element instanceof ISvnRepository) {
            ISvnRepository repo = (ISvnRepository)element;
            Timestamp lastScan = repo.getLastScan();
            if (lastScan == null) {
                label.setText(NLS.bind((String)SVNRCPMessages.SvnLabelProvider_0, (Object[])new Object[]{repo.getUrl(), repo.getRevision()}));
            } else {
                label.setText(NLS.bind((String)SVNRCPMessages.SvnLabelProvider_1, (Object[])new Object[]{repo.getUrl(), repo.getRevision(), lastScan.toString()}));
            }
            label.setImage(this.getImage(ImagePool.SVN_REPO));
        }
    }

    protected void elementAdded(Object element) {
        ITeamRepository repository;
        ISvnClientLibrary clientLibrary;
        super.elementAdded(element);
        if (element instanceof SvnRepositoryWrapper && !this.libraries.contains(clientLibrary = Utils.getClientLibrary(repository = ((SvnRepositoryWrapper)((Object)element)).getRepository()))) {
            this.libraries.add(clientLibrary);
            clientLibrary.addGenericListener((Object)"repositories", (IListener)this);
        }
    }

    public void dispose() {
        super.dispose();
        for (ISvnClientLibrary library : this.libraries) {
            library.removeGenericListener((Object)"repositories", (IListener)this);
        }
    }

    public void handleEvents(final List events) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ArrayList<SvnRepositoryWrapper> elements = new ArrayList<SvnRepositoryWrapper>();
                ISetWithListeners knownElements = SvnLabelProvider.this.getKnownElements();
                for (Object object : events) {
                    if (!(object instanceof RepositoryEvent)) continue;
                    RepositoryEvent re = (RepositoryEvent)object;
                    ISvnRepository[] repositories = re.getRepositories();
                    int i = 0;
                    while (i < repositories.length) {
                        ISvnRepository repository = repositories[i];
                        SvnRepositoryWrapper wrappedElement = new SvnRepositoryWrapper(re.getTeamRepository(), (IItem)repository);
                        if (knownElements.toCollection().contains((Object)wrappedElement)) {
                            elements.add(wrappedElement);
                        }
                        ++i;
                    }
                }
                SvnLabelProvider.this.fireChangeEvent(elements);
            }
        });
    }
}

