/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.view;

import com.ibm.team.filesystem.ui.queries.KnownTeamRepositoryQuery;
import com.ibm.team.filesystem.ui.views.AbstractRepositoryTreeProvider;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreePathRunnable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.openactions.OpenAction;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.parts.AbstractViewPart;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.IPartSite;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.view.SvnRepositoryQuery;
import com.ibm.team.scm.svn.rcp.ui.internal.view.SvnRepositoryWrapper;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;

public class SvnConnectionsView
extends AbstractViewPart {
    private SimpleTreeViewer viewer;
    private PushAction refreshAllAction;

    public SvnConnectionsView(IPartSite site, Object input) {
        super(site, input);
        this.viewer = new SimpleTreeViewer(site.getParent(), (ITreeProvider)new AbstractRepositoryTreeProvider(){

            public ISetWithListeners getChildren(Object element) {
                if (element instanceof ITeamRepositoryService) {
                    return new KnownTeamRepositoryQuery();
                }
                if (element instanceof ITeamRepository) {
                    ITeamRepository repository = (ITeamRepository)element;
                    return new SvnRepositoryQuery(repository, SvnConnectionsView.this.getSite().getOperationRunner());
                }
                return null;
            }
        }).setProgressService((IBusyHandler)site);
        this.viewer.setDoubleClickHandler((ITreePathRunnable)new OpenAction(site.getPage()){

            public void run(TreePath path, Shell targetShell) {
                Object selection = path.getLastSegment();
                if (selection instanceof ITeamRepository) {
                    SvnConnectionsView.this.viewer.toggleExpandedState(path);
                } else {
                    super.run(selection, targetShell);
                }
            }
        });
        site.setSelectionProvider(this.viewer.getSelectionProvider());
        ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)this.viewer.getContextMenu());
        ContextMenuHelper.addNewSubmenu((IMenuManager)this.viewer.getContextMenu(), (boolean)true);
        site.registerContextMenu(this.viewer.getContextMenu(), this.viewer.getSelectionProvider());
        this.refreshAllAction = new PushAction(ImagePool.REFRESH_ICON, SVNRCPMessages.SvnConnectionsView_0, new Runnable(){

            public void run() {
                SvnConnectionsView.this.getSite().getOperationRunner().enqueue(SVNRCPMessages.SvnConnectionsView_1, new Operation(){

                    public void run(IProgressMonitor reporter, IStatusCollector problems) throws OperationFailedException {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                SvnConnectionsView.this.viewer.refresh();
                            }
                        });
                    }
                });
            }
        });
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection selection = SvnConnectionsView.this.viewer.getSelection();
                String message = null;
                if (selection != null) {
                    int size = selection.size();
                    if (size == 1) {
                        Object firstElement = selection.getFirstElement();
                        if (firstElement instanceof SvnRepositoryWrapper) {
                            String name;
                            SvnRepositoryWrapper wrapper = (SvnRepositoryWrapper)((Object)firstElement);
                            message = name = wrapper.getSvnRepository().getUrl();
                        }
                    } else {
                        message = NLS.bind((String)SVNRCPMessages.SvnConnectionsView_2, (Object)size);
                    }
                }
                ((IViewSite)SvnConnectionsView.this.getSite().getPart().getSite()).getActionBars().getStatusLineManager().setMessage(message);
            }
        });
        GridLayoutFactory.fillDefaults().generateLayout(site.getParent());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)site.getParent(), "com.ibm.team.scm.svn.rcp.ui.jazzSvnView");
        this.viewer.setInput((Object)TeamPlatform.getTeamRepositoryService());
    }

    public void addMenuEntries(List output) {
        output.add(this.refreshAllAction);
        super.addMenuEntries(output);
    }

    public void addToolbarEntries(List output) {
        output.add(this.refreshAllAction);
        super.addToolbarEntries(output);
    }
}

