/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.importz.internal.utils.PathUtils;
import com.ibm.team.scm.client.importz.svn.internal.ISVN2ComponentPathMapping;
import com.ibm.team.scm.svn.rcp.ui.internal.Activator;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.Editor;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.Reporter;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.RevisionTree;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNChange;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.SubMonitor;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncRoot {
    public static final boolean DEBUG = Activator.DEBUG_IMPORT;
    private final ISVN2ComponentPathMapping mapping;
    final RevisionTree tree = new RevisionTree();
    private final String rootPath;

    public String getRootPath() {
        return this.rootPath;
    }

    public SyncRoot(ISVN2ComponentPathMapping mapping, String rootPath) {
        this.mapping = mapping;
        this.rootPath = rootPath;
    }

    public ISVNEditor createEditor(SubMonitor progress) {
        return new Editor(this.tree, progress);
    }

    public ISVNReporterBaton createReporter(long revision, SubMonitor progress) {
        return new Reporter(this.tree, revision, progress);
    }

    public List<SVNChange> getChanges(ISVNEditor editor) {
        return ((Editor)editor).getChanges();
    }

    public RevisionTree getTree() {
        return this.tree;
    }

    public String getComponentRelativePath(String path) {
        return this.mapping.getComponentRelativePath(PathUtils.appendPath((String)this.rootPath, (String)path));
    }

    public void dispose() {
        this.tree.dispose();
    }

    public boolean isContentChange(String path, File newFile) throws TeamRepositoryException {
        File currentFile = this.tree.getCurrentFileFor(path);
        if (currentFile != null && currentFile.exists() && newFile.exists() && currentFile.length() == newFile.length()) {
            return !this.filesEqual(currentFile, newFile);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean filesEqual(File file1, File file2) throws TeamRepositoryException {
        boolean bl;
        InputStream in2;
        block13: {
            InputStream in1 = null;
            in2 = null;
            try {
                in1 = new BufferedInputStream(new FileInputStream(file1));
                in2 = new BufferedInputStream(new FileInputStream(file2));
                bl = this.streamsEqual(in1, in2);
                if (in1 == null) break block13;
            }
            catch (IOException e) {
                try {
                    throw new TeamRepositoryException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (in1 != null) {
                        try {
                            in1.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (in2 == null) throw throwable;
                    try {
                        in2.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                in1.close();
            }
            catch (IOException iOException) {}
        }
        if (in2 == null) return bl;
        try {
            in2.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
    }

    private boolean streamsEqual(InputStream in1, InputStream in2) throws IOException {
        int b1 = in1.read();
        int b2 = in2.read();
        while (b1 != -1 && b2 != -1 && b1 == b2) {
            b1 = in1.read();
            b2 = in2.read();
        }
        return b1 == b2;
    }

    public String getFullPath(SVNChange change) {
        return PathUtils.appendPath((String)this.getRootPath(), (String)change.getPath());
    }
}

