/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.scm.client.importz.IFileProperties;
import com.ibm.team.scm.client.importz.spi.FileProperties;
import com.ibm.team.scm.client.importz.svn.internal.SVNFileProperties;

public class SVNFilePropertiesDelta
extends SVNFileProperties {
    private boolean contentTypeChanged;
    private boolean eolStyleChanged;
    private boolean executeChanged;

    public void setContentType(String contentType) {
        this.contentTypeChanged = true;
        super.setContentType(contentType);
    }

    public void setEolStyle(String eolStyle) {
        this.eolStyleChanged = true;
        super.setEolStyle(eolStyle);
    }

    public void setExecutable(boolean executable) {
        this.executeChanged = true;
        super.setExecutable(executable);
    }

    public IFileProperties applyTo(IFileProperties fileProperties) {
        if (fileProperties == null) {
            return this.toIFileProperties();
        }
        if (!this.isPropertiesModified()) {
            return fileProperties;
        }
        return new FileProperties(this.getLineDelimiter(fileProperties), this.getContentType(fileProperties), fileProperties.getEncoding(), this.getExecutable(fileProperties));
    }

    private boolean getExecutable(IFileProperties fileProperties) {
        if (this.executeChanged) {
            return this.isExecutable();
        }
        return fileProperties.isExecutable();
    }

    private String getContentType(IFileProperties fileProperties) {
        if (this.contentTypeChanged) {
            return this.getContentType();
        }
        return fileProperties.getContentType();
    }

    private LineDelimiter getLineDelimiter(IFileProperties fileProperties) {
        if (this.eolStyleChanged) {
            return this.getLineDelimiter();
        }
        return fileProperties.getLineDelimiter();
    }

    private boolean isPropertiesModified() {
        return this.executeChanged || this.contentTypeChanged || this.eolStyleChanged;
    }
}

