/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.Credentials;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordDialog
extends TitleAreaDialog {
    private final String repositoryURL;
    private final Credentials credentials;
    private final String errorMessage;

    protected PasswordDialog(String repositoryURL, Credentials credentials, String errorMessage) {
        super(null);
        this.repositoryURL = repositoryURL;
        this.credentials = credentials;
        this.errorMessage = errorMessage;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(SVNRCPMessages.SVNImporter_3);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).numColumns(2).equalWidth(false).applyTo(composite);
        composite.setLayoutData((Object)new GridData(1808));
        Label description = new Label(composite, 64);
        description.setText(NLS.bind((String)SVNRCPMessages.SVNImporter_0, (Object)this.repositoryURL));
        GridDataFactory.defaultsFor((Control)description).grab(true, false).span(2, 1).applyTo((Control)description);
        Label usernameLabel = new Label(composite, 0);
        usernameLabel.setText(SVNRCPMessages.SVNImporter_1);
        GridDataFactory.defaultsFor((Control)usernameLabel).grab(false, false).align(1, 0x1000000).applyTo((Control)usernameLabel);
        final Text usernameText = new Text(composite, 2048);
        GridDataFactory.defaultsFor((Control)usernameText).grab(true, false).align(4, 0x1000000).applyTo((Control)usernameText);
        String username = this.credentials.getUsername();
        usernameText.setText(username == null ? "" : username);
        usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PasswordDialog.this.credentials.setUsername(usernameText.getText());
            }
        });
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText(SVNRCPMessages.SVNImporter_2);
        GridDataFactory.defaultsFor((Control)passwordLabel).grab(false, false).align(1, 0x1000000).applyTo((Control)passwordLabel);
        final Text passwordText = new Text(composite, 0x400800);
        GridDataFactory.defaultsFor((Control)passwordText).grab(true, false).align(4, 0x1000000).applyTo((Control)passwordText);
        String password = this.credentials.getPassword();
        passwordText.setText(password == null ? "" : password);
        passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PasswordDialog.this.credentials.setPassword(passwordText.getText());
            }
        });
        this.setTitle(SVNRCPMessages.SVNImporter_3);
        this.setMessage(NLS.bind((String)SVNRCPMessages.SVNImporter_0, (Object)this.repositoryURL));
        if (this.errorMessage != null) {
            this.setErrorMessage(this.errorMessage);
        }
        return composite;
    }
}

