/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui.teamnavigator;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.rcp.ui.LoginAction;
import com.ibm.team.process.internal.rcp.ui.LogoutAction;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.RepositoryLabelProvider;
import com.ibm.team.process.internal.rcp.ui.RepositoryListener;
import com.ibm.team.process.internal.rcp.ui.TeamArtifactsNavigator;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.process.rcp.ui.teamnavigator.IProcessAreaCategory;
import com.ibm.team.process.rcp.ui.teamnavigator.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.utils.ItemHandleComparer;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.UIJob;

public class ProjectAreaCategory
extends Category
implements IProcessAreaCategory {
    private TreeViewer fViewer;
    private StandardLabelProvider fCategoryLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    private TeamArtifactsNavigator fTAN;
    private IElementComparer fItemHandleComparer = new ItemHandleComparer();
    private RepositoryListener fRepositoryListener;
    private IConnectedProjectAreaRegistryListener fProjectAreaRegistryListener = new IConnectedProjectAreaRegistryListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectedProjectAreaRegistryChanged(final IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            TreeViewer viewer;
            1 var3_2 = this;
            synchronized (var3_2) {
                if (ProjectAreaCategory.this.fViewer == null) {
                    return;
                }
                viewer = ProjectAreaCategory.this.fViewer;
            }
            int type = changeEvent.getType();
            switch (type) {
                case 0: {
                    ProjectAreaCategory.this.updateUIForConnectedProjectAreaChange(null);
                    return;
                }
                case 3: {
                    if (changeEvent.isResortRequired()) {
                        ProjectAreaCategory.this.updateUIForConnectedProjectAreaChange(null);
                    } else {
                        ProjectAreaCategory.this.asyncExec(viewer.getControl(), new Runnable(){

                            public void run() {
                                viewer.update((Object)changeEvent.getProjectAreaHandle(), null);
                                ProjectAreaCategory.this.fTAN.updateDescription();
                            }
                        });
                    }
                    return;
                }
                case 4: {
                    ProjectAreaCategory.this.updateUIForConnectedProjectAreaChange(changeEvent.getProjectAreaHandle());
                    return;
                }
                case 5: 
                case 6: 
                case 7: {
                    if (!changeEvent.isFromSharedItemChange() && type != 7) {
                        ProjectAreaCategory.this.asyncExec(viewer.getControl(), new Runnable(){

                            public void run() {
                                ProjectAreaCategory.this.fTAN.updateDescription();
                            }
                        });
                    }
                    ProjectAreaCategory.this.updateUIForConnectedProjectAreaChange(changeEvent.getProjectAreaHandle());
                    return;
                }
            }
            final IProjectAreaHandle removedProjectArea = changeEvent.getRemovedProjectArea();
            if (removedProjectArea != null) {
                ProjectAreaCategory.this.asyncExec(viewer.getControl(), new Runnable(){

                    public void run() {
                        viewer.remove(viewer.getInput(), new Object[]{removedProjectArea});
                        ProjectAreaCategory.this.fTAN.updateDescription();
                    }
                });
            } else {
                final IProjectAreaHandle addedProjectArea = changeEvent.getAddedProjectArea();
                ProjectAreaCategory.this.asyncExec(viewer.getControl(), new Runnable(){

                    public void run() {
                        viewer.add(viewer.getInput(), (Object)addedProjectArea);
                        viewer.setSelection((ISelection)new StructuredSelection((Object)addedProjectArea), true);
                        ProjectAreaCategory.this.fTAN.updateDescription();
                    }
                });
            }
        }
    };
    private boolean fRefreshing;

    public boolean isTeamAreaCategory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUIForConnectedProjectAreaChange(final IProjectAreaHandle projectAreaHandle) {
        TreeViewer viewer;
        ProjectAreaCategory projectAreaCategory = this;
        synchronized (projectAreaCategory) {
            if (this.fViewer == null || this.fRefreshing) {
                return;
            }
            viewer = this.fViewer;
            this.fRefreshing = true;
        }
        new UIJob(Messages.ProjectAreaCategory_0){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (viewer.getControl().isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    if (projectAreaHandle == null) {
                        viewer.refresh();
                    } else {
                        viewer.refresh((Object)projectAreaHandle);
                    }
                    ProjectAreaCategory.this.fTAN.updateDescription();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    ProjectAreaCategory.this.fRefreshing = false;
                }
            }
        }.schedule();
    }

    public void init() {
        ConnectedProjectAreaRegistry.getDefault().addListener(this.fProjectAreaRegistryListener);
    }

    public Object convertModel(Object modelElem) {
        return modelElem;
    }

    public Object convertSelection(Object selectionElem) {
        return selectionElem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ConnectedProjectAreaRegistry.getDefault().removeListener(this.fProjectAreaRegistryListener);
        this.fRepositoryListener.dispose();
        ProjectAreaCategory projectAreaCategory = this;
        synchronized (projectAreaCategory) {
            this.fViewer = null;
            this.fTAN = null;
        }
        this.fCategoryLabelProvider.dispose();
    }

    public Object[] getCategoryElements() {
        return ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null).toArray();
    }

    public Image getImage(Object categoryElement) {
        return this.fCategoryLabelProvider.getImage(categoryElement);
    }

    public String getName() {
        return Messages.ProjectAreaCategory_1;
    }

    public String getText(Object categoryElement) {
        return this.fCategoryLabelProvider.getText(categoryElement);
    }

    public boolean isCategoryElement(Object potentialElement) {
        if (potentialElement instanceof IProjectAreaHandle) {
            return ConnectedProjectAreaRegistry.getDefault().isConnectedProjectArea((IProjectAreaHandle)potentialElement);
        }
        return false;
    }

    public boolean isValid(Object element) {
        IProjectAreaHandle projectAreaHandle;
        ITeamRepository teamRepository;
        if (element instanceof IProjectAreaHandle && (teamRepository = (ITeamRepository)(projectAreaHandle = (IProjectAreaHandle)element).getOrigin()).loggedIn() && teamRepository.getErrorState() == 0) {
            return ((ITeamRepository)projectAreaHandle.getOrigin()).itemManager().getSharedItemIfKnown((IItemHandle)projectAreaHandle) != null;
        }
        return false;
    }

    public void makeValid(Object element, IProgressMonitor monitor) {
        if (element instanceof IProjectAreaHandle) {
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)element;
            ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
            if (!teamRepository.loggedIn() || teamRepository.getErrorState() != 0) {
                try {
                    teamRepository.login(monitor);
                }
                catch (TeamRepositoryException e) {
                    ProcessRCPUIPlugin.getDefault().log(e);
                    return;
                }
            }
            try {
                teamRepository.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 1, monitor);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                teamRepository.itemManager().applyItemDeletes(Collections.singletonList(element));
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
    }

    public String getValidationJobName(Object element) {
        if (element instanceof IProjectAreaHandle) {
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)element;
            String repoName = RepositoryLabelProvider.getRepositoryText((ITeamRepository)projectAreaHandle.getOrigin());
            return NLS.bind((String)Messages.ProjectAreaCategory_3, (Object)repoName);
        }
        return Messages.ProjectAreaCategory_2;
    }

    public void refreshCategoryElement(final Object element) {
        if (element instanceof IProjectAreaHandle) {
            final IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)element;
            Job job = new Job(Messages.ProjectAreaCategory_4){

                protected IStatus run(IProgressMonitor monitor) {
                    ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
                    try {
                        IItem fetchCompleteItem;
                        UUID stateId;
                        if (!teamRepository.loggedIn() || teamRepository.getErrorState() != 0) {
                            teamRepository.login(monitor);
                        }
                        if ((stateId = (fetchCompleteItem = teamRepository.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 1, monitor)).getStateId()) != null && stateId.equals((Object)projectAreaHandle.getStateId())) {
                            ProjectAreaCategory.this.asyncExec(ProjectAreaCategory.this.fViewer.getControl(), new Runnable(){

                                public void run() {
                                    ProjectAreaCategory.this.fViewer.refresh(element);
                                }
                            });
                        }
                    }
                    catch (ItemNotFoundException itemNotFoundException) {
                        teamRepository.itemManager().applyItemDeletes(Collections.singletonList(element));
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(4, "com.ibm.team.process.rcp.ui", 0, Messages.ProjectAreaCategory_5, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public boolean open(final IWorkbenchSite site, final Object categoryElement) {
        if (super.open(site, categoryElement)) {
            return true;
        }
        if (!this.isValid(categoryElement)) {
            UIUpdaterJob updater = new UIUpdaterJob(Messages.ProjectAreaCategory_6){

                public IStatus runInBackground(IProgressMonitor monitor) {
                    ProjectAreaCategory.this.makeValid(categoryElement, monitor);
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    IProjectAreaHandle projectAreaHandle;
                    ITeamRepository teamRepository;
                    if (categoryElement instanceof IProjectAreaHandle && (teamRepository = (ITeamRepository)(projectAreaHandle = (IProjectAreaHandle)categoryElement).getOrigin()).loggedIn() && teamRepository.getErrorState() == 0) {
                        ProjectAreaCategory.this.open(site, teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)projectAreaHandle));
                    }
                    return super.runInUI(monitor);
                }
            };
            updater.schedule();
            return true;
        }
        return false;
    }

    public boolean equals(Object e1, Object e2) {
        if (e1 instanceof IProjectAreaHandle && e2 instanceof IProjectAreaHandle) {
            return this.fItemHandleComparer.equals(e1, e2);
        }
        return super.equals(e1, e2);
    }

    public int hashCode(Object element) {
        if (element instanceof IProjectAreaHandle) {
            return this.fItemHandleComparer.hashCode(element);
        }
        return super.hashCode(element);
    }

    public void setViewer(TreeViewer viewer) {
        this.fViewer = viewer;
        this.fRepositoryListener = new RepositoryListener((StructuredViewer)this.fViewer, new String[]{"name"}, true);
    }

    public void setTeamArtifactsNavigator(TeamArtifactsNavigator tan) {
        this.fTAN = tan;
    }

    public void contributeContextMenuActions(IWorkbenchSite site, IMenuManager manager, IStructuredSelection selection) {
        Object first;
        super.contributeContextMenuActions(site, manager, selection);
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IProjectAreaHandle) {
            IProjectAreaHandle handle = (IProjectAreaHandle)first;
            ITeamRepository repository = (ITeamRepository)handle.getOrigin();
            if (repository.loggedIn() && repository.getErrorState() == 0) {
                manager.appendToGroup("jazz.refactoring.group", (IAction)new LogoutAction(selection));
            } else {
                manager.appendToGroup("jazz.refactoring.group", (IAction)new LoginAction(selection));
            }
        }
    }

    private void asyncExec(final Control control, final Runnable runnable) {
        block3: {
            if (control != null && !control.isDisposed()) {
                try {
                    control.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!control.isDisposed()) {
                                runnable.run();
                            }
                        }
                    });
                }
                catch (SWTException e) {
                    if (e.code == 24) break block3;
                    throw e;
                }
            }
        }
    }
}

