/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.ContributorSelectionBlock;
import com.ibm.team.process.internal.rcp.ui.HelpContextIds;
import com.ibm.team.process.internal.rcp.ui.IBlockContainer;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TeamContributorSelectionDialog
extends TitleAreaDialog
implements IBlockContainer {
    private static final String DIALOG_SETTINGS = "com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog";
    private static final String DIALOG_BOUNDS_SETTINGS = "DialogBoundsSettings";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private ITeamRepository fRepository;
    private boolean fMultiselection;
    private ContributorSelectionBlock fSelectionBlock;
    private List fFilteredContributors;
    private ResourceManager fResourceManager;
    private String fSeparatorLabel;
    private List fFilters;
    private boolean fImporting;
    private Object[] fResult;
    private boolean fOpenEditorOnFinish;

    public TeamContributorSelectionDialog(Shell shell, ITeamRepository repository) {
        this(shell, repository, Collections.EMPTY_LIST, true, false);
    }

    public TeamContributorSelectionDialog(Shell shell, ITeamRepository repository, List filteredContributors, boolean multi) {
        this(shell, repository, filteredContributors, multi, false);
    }

    public TeamContributorSelectionDialog(Shell shell, ITeamRepository repository, List filteredContributors, boolean multi, boolean importing) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        Assert.isTrue((repository.getId() != null ? 1 : 0) != 0);
        this.fRepository = repository;
        this.fMultiselection = multi;
        this.fFilteredContributors = filteredContributors;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.fImporting = importing;
        if (this.fImporting) {
            this.setTitleImage(this.fResourceManager.createImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.process.rcp.ui", (String)"icons/wizban/impt_user_wizban.gif")));
        } else {
            this.setTitleImage(this.fResourceManager.createImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.process.rcp.ui", (String)"icons/wizban/contributor_wizban.gif")));
        }
    }

    public IContributorHandle[] getContributorResult() {
        Object[] handles = this.fSelectionBlock.getResult();
        IContributorHandle[] result = new IContributorHandle[handles.length];
        System.arraycopy(handles, 0, result, 0, handles.length);
        return result;
    }

    protected Control createContents(Composite parent) {
        HelpContextIds.hookHelpListener((Control)parent, this.fImporting ? "com.ibm.team.process.rcp.ui.csh_import_user" : "com.ibm.team.process.rcp.ui.csh_select_user");
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite blockContainer = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        blockContainer.setLayout((Layout)layout);
        blockContainer.setLayoutData((Object)new GridData(1808));
        this.fSelectionBlock = new ContributorSelectionBlock(this.fMultiselection, this.fImporting, this, this.fRepository, this.fFilteredContributors);
        if (this.fSeparatorLabel != null) {
            this.fSelectionBlock.setSeparatorLabel(this.fSeparatorLabel);
        }
        if (this.fFilters != null) {
            Iterator iterator = this.fFilters.iterator();
            while (iterator.hasNext()) {
                this.fSelectionBlock.addListFilter((ViewerFilter)iterator.next());
            }
        }
        Control block = this.fSelectionBlock.create(blockContainer);
        this.fSelectionBlock.restoreBlockSettings(this.getDialogSettings());
        this.fSelectionBlock.applyFilter();
        return block;
    }

    public void create() {
        super.create();
        this.getDefaultButton().setEnabled(false);
        this.fSelectionBlock.getPatternControl().setFocus();
        this.setTitle(Messages.TeamContributorSelectionDialog_2);
        this.setDefaultMessage();
        if (this.fImporting) {
            this.getShell().setText(Messages.TeamContributorSelectionDialog_3);
        } else {
            this.getShell().setText(Messages.TeamContributorSelectionDialog_4);
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = ProcessRCPUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = ProcessRCPUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = this.getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_BOUNDS_SETTINGS);
        if (section == null) {
            section = settings.addNewSection(DIALOG_BOUNDS_SETTINGS);
            section.put(DIALOG_HEIGHT, 500);
            section.put(DIALOG_WIDTH, 600);
        }
        return section;
    }

    public boolean close() {
        this.fSelectionBlock.storeBlockSettings(this.getDialogSettings());
        this.fResourceManager.dispose();
        this.fSelectionBlock.dispose();
        return super.close();
    }

    public GridData setLayoutData(Button button) {
        this.setButtonLayoutData(button);
        return (GridData)button.getLayoutData();
    }

    public void setStatus(IStatus status) {
        int type = 0;
        if (status != null) {
            switch (status.getSeverity()) {
                case 4: {
                    type = 3;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 1: {
                    type = 1;
                }
            }
        }
        this.getDefaultButton().setEnabled(type != 3);
        if (status == null || status.isOK() && status.getCode() != 55) {
            this.setDefaultMessage();
        } else if (status.getMessage().length() != 0) {
            this.setMessage(status.getMessage(), type);
        }
    }

    private void setDefaultMessage() {
        if (this.fImporting) {
            this.setMessage(Messages.TeamContributorSelectionDialog_5);
        } else {
            this.setMessage(Messages.TeamContributorSelectionDialog_6);
        }
    }

    protected void computeResult() {
        this.fSelectionBlock.computeResult(true);
        this.fOpenEditorOnFinish = this.fSelectionBlock.openEditorsOnFinish();
        this.setResult(this.fSelectionBlock.getResult());
    }

    private void setResult(Object[] result) {
        this.fResult = result;
    }

    public Object[] getResult() {
        return this.fResult;
    }

    public Object getFirstResult() {
        if (this.fResult == null || this.fResult.length == 0) {
            return null;
        }
        return this.fResult[0];
    }

    public Button getDefaultButton() {
        return this.getButton(0);
    }

    public void finish() {
        this.okPressed();
    }

    protected void okPressed() {
        this.computeResult();
        super.okPressed();
    }

    public void addListFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList();
        }
        this.fFilters.add(filter);
    }

    public void setSeparatorLabel(String separatorLabel) {
        this.fSeparatorLabel = separatorLabel;
    }

    public boolean allowOpenEditorsOnFinish() {
        return this.fImporting;
    }

    public boolean openEditorsOnFinish() {
        return this.fOpenEditorOnFinish;
    }

    protected void cancelPressed() {
        if (this.fSelectionBlock.isSearching()) {
            this.fSelectionBlock.cancelSearch();
            return;
        }
        super.cancelPressed();
    }
}

