/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.process.rcp.ui.RepositorySelectionPart;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.parts.AbstractControlSite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RepositorySelectionPage
extends WizardPage {
    private RepositorySelectionPart fPart;

    public RepositorySelectionPage(String title, String description) {
        super(title);
        this.setTitle(title);
        this.setDescription(description);
    }

    public RepositorySelectionPage(String description) {
        this(Messages.RepositorySelectionPage_0, description);
    }

    public void createControl(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(Geometry.createDiffRectangle((int)5, (int)5, (int)5, (int)5)).applyTo(wrapper);
        Composite composite = new Composite(wrapper, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        AbstractControlSite site = new AbstractControlSite(composite){

            public void setStatus(IStatus status) {
                String statusMessage = null;
                if (status != null && !status.isOK()) {
                    statusMessage = status.getMessage();
                }
                if (statusMessage == null) {
                    RepositorySelectionPage.this.setMessage(null);
                } else {
                    RepositorySelectionPage.this.setMessage(statusMessage, 3);
                }
                RepositorySelectionPage.this.setPageComplete(statusMessage == null);
            }

            public void close() {
            }
        };
        RepositorySelectionPart.IRepositorySelectionListener selectionListener = new RepositorySelectionPart.IRepositorySelectionListener(){
            private ITeamRepository fLastRepo;

            public void repositorySelected(ITeamRepository repo) {
                if (this.fLastRepo == null || repo != this.fLastRepo) {
                    RepositorySelectionPage.this.setPageComplete(repo != null);
                }
                this.fLastRepo = repo;
            }
        };
        this.fPart = new RepositorySelectionPart(site.getParent(), selectionListener, this.createDoubleClickListener());
        this.setControl((Control)wrapper);
    }

    public RepositorySelectionPart.IRepositorySelectionListener createDoubleClickListener() {
        return new RepositorySelectionPart.IRepositorySelectionListener(){

            public void repositorySelected(ITeamRepository repo) {
                RepositorySelectionPage.this.getContainer().showPage(RepositorySelectionPage.this.getNextPage());
            }
        };
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public ITeamRepository getTeamRepository() {
        return this.fPart.getTeamRepository();
    }

    public void dispose() {
        if (this.fPart != null) {
            this.fPart.dispose();
            this.fPart = null;
        }
        super.dispose();
    }
}

