/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.HistoryCombo;
import com.ibm.team.process.internal.rcp.ui.RepositoryInfo;
import com.ibm.team.process.rcp.ui.IStatusHandler;
import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.transport.client.TeamServerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class RepositoryCreationPart {
    private HistoryCombo uriCombo;
    private HistoryCombo userIdText;
    private HistoryCombo nameCombo;
    private Text passwordText;
    private Button rememberPassword;
    private Button autoLogin;
    private boolean nameOverriden = false;
    private boolean nameHasFocus = false;
    private boolean initialized = false;
    private String partName = "";
    private Text timeoutText;
    private List requiredFields = new ArrayList();
    private final IStatusHandler fSite;
    private static final int ALREADY_EXISTS = 9999;
    private static final int NO_SPACES = 9998;
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            RepositoryCreationPart.this.passwordText.setEnabled(RepositoryCreationPart.this.rememberPassword.getSelection());
        }
    };
    private Preferences dialogPrefs;
    private RepositoryInfo fRepositoryInformation;
    private ControlDecoration fURIDecoration;
    private ControlDecoration fUserIdDecoration;

    public RepositoryCreationPart(IStatusHandler site, RepositoryInfo repositoryInformation) {
        this.fSite = site;
        this.fRepositoryInformation = repositoryInformation;
        this.dialogPrefs = this.getConfigPrefs().node("dialog");
        Composite parent = site.getComposite();
        Group uriComposite = new Group(parent, 0);
        uriComposite.setText(Messages.RepositoryCreationPart_2);
        Label uriLabel = new Label((Composite)uriComposite, 0);
        uriLabel.setText(Messages.RepositoryCreationPart_3);
        this.uriCombo = new HistoryCombo((Composite)uriComposite, this.dialogPrefs.node("uri"), false);
        if (this.uriCombo.getHistory().length == 0) {
            this.uriCombo.addToHistory("https://localhost:9443/jazz", true);
        }
        Label nameLabel = new Label((Composite)uriComposite, 0);
        nameLabel.setText(Messages.RepositoryCreationPart_7);
        this.nameCombo = new HistoryCombo((Composite)uriComposite, this.dialogPrefs.node("name"), true);
        this.nameCombo.getCombo().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                RepositoryCreationPart.this.nameHasFocus = false;
            }

            public void focusGained(FocusEvent e) {
                if (RepositoryCreationPart.this.nameCombo.getCombo().getText().equals("") && !RepositoryCreationPart.this.nameOverriden) {
                    RepositoryCreationPart.this.setSuggestedName();
                }
                RepositoryCreationPart.this.nameHasFocus = true;
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout((Composite)uriComposite);
        Group authenticationComposite = new Group(parent, 0);
        authenticationComposite.setText(Messages.RepositoryCreationPart_10);
        Label userID = new Label((Composite)authenticationComposite, 0);
        userID.setText(Messages.RepositoryCreationPart_11);
        this.userIdText = new HistoryCombo((Composite)authenticationComposite, this.dialogPrefs.node("userId"), false);
        Label password = new Label((Composite)authenticationComposite, 0);
        password.setText(Messages.RepositoryCreationPart_13);
        this.passwordText = new Text((Composite)authenticationComposite, 0x400804);
        this.rememberPassword = new Button((Composite)authenticationComposite, 32);
        this.rememberPassword.setText(Messages.RepositoryCreationPart_14);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryCreationPart.this.updateRepositoryInformation();
            }
        };
        this.rememberPassword.addSelectionListener((SelectionListener)selectionAdapter);
        GridDataFactory.generate((Control)this.rememberPassword, (int)2, (int)1);
        this.autoLogin = new Button((Composite)authenticationComposite, 32);
        this.autoLogin.setText(Messages.RepositoryCreationPart_15);
        this.autoLogin.addSelectionListener((SelectionListener)selectionAdapter);
        GridDataFactory.generate((Control)this.autoLogin, (int)2, (int)1);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout((Composite)authenticationComposite);
        Group detailsSectionComposite = new Group(parent, 0);
        detailsSectionComposite.setText(Messages.RepositoryCreationPart_16);
        Label connectionTimeout = new Label((Composite)detailsSectionComposite, 0);
        connectionTimeout.setText(Messages.RepositoryCreationPart_17);
        this.timeoutText = new Text((Composite)detailsSectionComposite, 2052);
        this.timeoutText.setText("");
        this.timeoutText.setTextLimit(4);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout((Composite)detailsSectionComposite);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.addDecorations();
        List updated = this.updateWidgets();
        ModifyListener modifyListener = new ModifyListener(updated){
            private List fModifiedByUser;
            {
                this.fModifiedByUser = list;
            }

            public void modifyText(ModifyEvent e) {
                if (!(e.widget != RepositoryCreationPart.this.uriCombo.getCombo() && e.widget != RepositoryCreationPart.this.userIdText.getCombo() || this.fModifiedByUser.contains(e.widget))) {
                    this.fModifiedByUser.add(e.widget);
                }
                if (e.widget == RepositoryCreationPart.this.nameCombo.getCombo()) {
                    RepositoryCreationPart.this.nameOverriden = RepositoryCreationPart.this.nameHasFocus;
                } else if (!(e.widget != RepositoryCreationPart.this.uriCombo.getCombo() && e.widget != RepositoryCreationPart.this.userIdText.getCombo() || RepositoryCreationPart.this.nameOverriden)) {
                    RepositoryCreationPart.this.setSuggestedName();
                }
                if (this.fModifiedByUser.size() == 2) {
                    RepositoryCreationPart.this.updateRepositoryInformation();
                }
            }
        };
        this.nameCombo.getCombo().addModifyListener(modifyListener);
        this.timeoutText.addModifyListener(modifyListener);
        this.passwordText.addModifyListener(modifyListener);
        this.uriCombo.getCombo().addModifyListener(modifyListener);
        this.userIdText.getCombo().addModifyListener(modifyListener);
        Dialog.applyDialogFont((Control)parent);
        this.rememberPassword.setSelection(this.fRepositoryInformation.fSavePassword);
        this.autoLogin.setSelection(this.fRepositoryInformation.fAutoLogin);
        this.rememberPassword.addSelectionListener(this.selectionListener);
        this.requiredFields.add(this.uriCombo);
        this.requiredFields.add(this.userIdText);
        this.initialized = true;
        this.uriCombo.getControl().setFocus();
    }

    public void dispose() {
        this.uriCombo.addToHistory();
        this.nameCombo.addToHistory();
        this.userIdText.addToHistory();
    }

    private Preferences getConfigPrefs() {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.ibm.team.process.rcp.ui");
        Preferences edilogPrefs = prefs.node(this.getClass().getName());
        return edilogPrefs;
    }

    private void setSuggestedName() {
        try {
            URI uri = new URI(this.uriCombo.getCombo().getText().trim());
            String hostnamePart = uri.getHost();
            if (hostnamePart != null) {
                this.nameCombo.getCombo().setText(hostnamePart);
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
    }

    protected void updateRepositoryInformation() {
        boolean oldBoolean;
        boolean newBoolean;
        int timeout;
        int newTimeOut;
        String oldText;
        if (!this.initialized) {
            return;
        }
        String newText = this.uriCombo.getCombo().getText().trim();
        if (!newText.equals(oldText = this.fRepositoryInformation.fURI)) {
            this.fRepositoryInformation.fURI = newText;
        }
        if (!(newText = this.nameCombo.getCombo().getText()).equals(oldText = this.fRepositoryInformation.fName)) {
            this.fRepositoryInformation.fName = newText;
        }
        if (!(newText = this.passwordText.getText()).equals(oldText = this.fRepositoryInformation.fPassword)) {
            this.fRepositoryInformation.fPassword = newText;
        }
        if ((newTimeOut = this.parseTimeout(this.timeoutText.getText())) != (timeout = this.fRepositoryInformation.fTimeout)) {
            this.fRepositoryInformation.fTimeout = newTimeOut;
        }
        if (!(newText = this.userIdText.getCombo().getText()).equals(oldText = this.fRepositoryInformation.fUserID)) {
            this.fRepositoryInformation.fUserID = newText;
        }
        if ((newBoolean = this.autoLogin.getSelection()) != (oldBoolean = this.fRepositoryInformation.fAutoLogin)) {
            this.fRepositoryInformation.fAutoLogin = newBoolean;
        }
        if ((newBoolean = this.rememberPassword.getSelection()) != (oldBoolean = this.fRepositoryInformation.fSavePassword)) {
            this.fRepositoryInformation.fSavePassword = newBoolean;
        }
        this.updateErrorState();
    }

    private List updateWidgets() {
        boolean newBoolean;
        boolean oldBoolean;
        String newText;
        ArrayList<Combo> requiredUpdated = new ArrayList<Combo>(2);
        String oldText = this.uriCombo.getCombo().getText();
        if (!oldText.equals(newText = this.fRepositoryInformation.fURI)) {
            this.uriCombo.getCombo().setText(newText);
            requiredUpdated.add(this.uriCombo.getCombo());
        }
        if (!(oldText = this.nameCombo.getCombo().getText()).equals(newText = this.fRepositoryInformation.fName)) {
            this.nameCombo.getCombo().setText(newText);
        }
        try {
            URI uri = new URI(this.uriCombo.getCombo().getText().trim());
            String hostnamePart = uri.getHost();
            if (newText != null && newText.trim().length() > 0 && !newText.equals(hostnamePart)) {
                this.nameOverriden = true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (!newText.equals(this.partName)) {
            this.partName = newText;
        }
        if (!(oldText = this.passwordText.getText()).equals(newText = this.fRepositoryInformation.fPassword)) {
            this.passwordText.setText(newText);
        }
        if (!(oldText = this.userIdText.getCombo().getText()).equals(newText = this.fRepositoryInformation.fUserID)) {
            this.userIdText.getCombo().setText(newText);
            requiredUpdated.add(this.userIdText.getCombo());
        }
        oldText = this.timeoutText.getText();
        int timeout = this.fRepositoryInformation.fTimeout;
        if (timeout < 0) {
            timeout = 0;
        }
        if (timeout > 9999) {
            timeout = 9999;
        }
        if (!oldText.equals(newText = Integer.toString(timeout))) {
            this.timeoutText.setText(newText);
        }
        if ((oldBoolean = this.autoLogin.getSelection()) != (newBoolean = this.fRepositoryInformation.fAutoLogin)) {
            this.autoLogin.setSelection(newBoolean);
        }
        if ((oldBoolean = this.rememberPassword.getSelection()) != (newBoolean = this.fRepositoryInformation.fSavePassword)) {
            this.rememberPassword.setSelection(newBoolean);
        }
        return requiredUpdated;
    }

    private boolean repositoryExists(String uri) {
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repos.length) {
            ITeamRepository repository = repos[i];
            Collection aliases = repository.getAliasRepositoryURIs();
            String repoUri = repository.getRepositoryURI();
            if (repoUri.equalsIgnoreCase(uri)) {
                return true;
            }
            for (String alias : aliases) {
                if (!uri.equalsIgnoreCase(alias)) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateErrorState() {
        this.fURIDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        for (Object field : this.requiredFields) {
            if (field == this.uriCombo) {
                int validationCode = this.validateURI();
                if (validationCode == 0) continue;
                this.fSite.setStatus((IStatus)new Status(4, "com.ibm.team.process.rcp.ui", this.getURIErrorMessage(validationCode)));
                this.fURIDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                return;
            }
            if (field != this.userIdText || this.isUserIdValid()) continue;
            this.fSite.setStatus((IStatus)new Status(4, "com.ibm.team.process.rcp.ui", Messages.RepositoryCreationPart_19));
            return;
        }
        String timeout = this.timeoutText.getText();
        if (this.parseTimeout(timeout) == -1) {
            this.fSite.setStatus((IStatus)new Status(4, "com.ibm.team.process.rcp.ui", Messages.RepositoryCreationPart_20));
            return;
        }
        this.fSite.setStatus(null);
    }

    private int parseTimeout(String timeout) {
        int t;
        block8: {
            block7: {
                if (timeout.length() == 0) {
                    return -1;
                }
                int i = 0;
                while (i < timeout.length()) {
                    char ch = timeout.charAt(i);
                    if ('0' > ch || ch > '9') {
                        return -1;
                    }
                    ++i;
                }
                try {
                    t = Integer.parseInt(timeout);
                    if (t >= 0) break block7;
                    return -1;
                }
                catch (NumberFormatException numberFormatException) {
                    return -1;
                }
            }
            if (t <= 9999) break block8;
            return -1;
        }
        return t;
    }

    private int validateURI() {
        String uri = this.uriCombo.getCombo().getText().trim();
        boolean exists = this.repositoryExists(uri);
        int spaces = uri.indexOf(" ");
        int validationCode = spaces != -1 ? 9998 : (this.fRepositoryInformation.fTeamRepository == null && exists ? 9999 : TeamServerFactory.INSTANCE.validateURL(uri));
        return validationCode;
    }

    private String getURIErrorMessage(int validationCode) {
        switch (validationCode) {
            case 3: {
                return Messages.RepositoryCreationPart_22;
            }
            case 4: {
                return Messages.RepositoryCreationPart_23;
            }
            case 2: {
                return Messages.RepositoryCreationPart_24;
            }
            case 9999: {
                return Messages.RepositoryCreationPart_25;
            }
            case 9998: {
                return Messages.RepositoryCreationPart_26;
            }
        }
        return Messages.RepositoryCreationPart_27;
    }

    private boolean isUserIdValid() {
        String userId = this.userIdText.getCombo().getText();
        return userId.length() > 0;
    }

    private void addDecorations() {
        this.fURIDecoration = new ControlDecoration(this.uriCombo.getControl(), 16512);
        this.fURIDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        this.fURIDecoration.show();
        this.fUserIdDecoration = new ControlDecoration(this.userIdText.getControl(), 16512);
        this.fUserIdDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        this.fUserIdDecoration.show();
    }
}

