/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.internal.rcp.ui.ProcessAreaContentProvider;
import com.ibm.team.process.rcp.ui.Messages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ProcessAreaSelectionPart {
    private TreeViewer fTreeViewer;
    private ProcessAreaContentProvider fContentProvider;
    private IProcessArea fSelectedArea;

    public ProcessAreaSelectionPart(Composite parent, boolean allowArchivedAreas) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.createTreeViewer(composite);
        if (allowArchivedAreas) {
            final Button showArchivedButton = new Button(composite, 32);
            showArchivedButton.setText(Messages.ProcessAreaSelectionPart_0);
            showArchivedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProcessAreaSelectionPart.this.setShowArchived(showArchivedButton.getSelection());
                }
            });
        }
        this.setShowArchived(allowArchivedAreas);
    }

    private TreeViewer createTreeViewer(Composite parent) {
        this.fTreeViewer = new TreeViewer(new Tree(parent, 2052));
        this.fContentProvider = new ProcessAreaContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof IProcessArea) {
                    ProcessAreaSelectionPart.this.setSelectedProcessArea((IProcessArea)firstElement);
                }
            }
        });
        GridData data = new GridData(1808);
        this.fTreeViewer.getTree().setLayoutData((Object)data);
        return this.fTreeViewer;
    }

    private void setSelectedProcessArea(IProcessArea selectedArea) {
        this.fSelectedArea = selectedArea;
    }

    public IProcessArea getSelectedProcessArea() {
        return this.fSelectedArea;
    }

    public void setInput(Object viewerInput) {
        this.getTreeViewer().setInput(viewerInput);
    }

    public void dispose() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
            this.fContentProvider = null;
        }
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected void setShowArchived(boolean show) {
        this.fContentProvider.setIncludeArchived(show);
    }
}

