/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.rcp.ui.internal.parts.DefaultLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.internal.tree.IParentProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConcurrentTreeContentProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.DirtyIndicationLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SetWithListenersToRemoveNotifier;
import com.ibm.team.repository.rcp.ui.openactions.OpenAction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class TreeProviderDomain
extends Domain
implements IExecutableExtension {
    private Object root;
    private ITreeProvider tree;
    private ConcurrentTreeContentProvider provider;
    private ITreePathLabelProvider fLabelProvider;
    private ILabelProviderListener labelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            TreeViewer viewer = TreeProviderDomain.this.provider.getViewer();
            if (viewer != null && !viewer.getTree().isDisposed()) {
                Object[] elements = event.getElements();
                if (elements == null) {
                    viewer.refresh();
                } else {
                    viewer.update(elements, null);
                }
            }
        }
    };
    private String name = "";
    private JobRunner rq;

    public Object getRoot() {
        if (this.root == null) {
            this.root = new DomainSubtreeRoot(this, new Object());
        }
        return this.root;
    }

    protected abstract ITreeProvider createTreeProvider();

    public final ITreeProvider getTreeProvider() {
        if (this.tree == null) {
            this.tree = this.createTreeProvider();
        }
        return this.tree;
    }

    protected IViewerLabelProvider createLabelProvider(IElementRemovedNotifier input) {
        return new StandardLabelProvider((ILabelProvider)new DefaultLabelProvider(), input);
    }

    public final ITreePathLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            ITreePathLabelProvider labelProv;
            ConcurrentTreeContentProvider provider = this.internalGetContentProvider();
            TreeViewer viewer = provider.getViewer();
            if (viewer == null) {
                return null;
            }
            final DirtyIndicationLabelProvider lp = new DirtyIndicationLabelProvider(viewer.getControl(), provider, this.createLabelProvider((IElementRemovedNotifier)new SetWithListenersToRemoveNotifier(provider.getKnownElements())));
            this.fLabelProvider = labelProv = new ITreePathLabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                    lp.addListener(listener);
                }

                public void dispose() {
                    lp.dispose();
                }

                public void updateLabel(ViewerLabel label, TreePath elementPath) {
                    Object element = elementPath.getLastSegment();
                    label.setText(lp.getText(element));
                    label.setImage(lp.getImage(element));
                }

                public boolean isLabelProperty(Object element, String property) {
                    return true;
                }

                public void removeListener(ILabelProviderListener listener) {
                    lp.removeListener(listener);
                }
            };
            this.fLabelProvider.addListener(this.labelProviderListener);
        }
        return this.fLabelProvider;
    }

    public boolean open(IWorkbenchPartSite site, IStructuredSelection selection) {
        Object element;
        if (selection.size() == 1 && OpenAction.getActionFor((Object)(element = selection.getFirstElement())) != null) {
            OpenAction.openObject((Object)element, (Shell)site.getShell(), (IWorkbenchPage)site.getPage());
            return true;
        }
        return super.open(site, selection);
    }

    public final ITreePathContentProvider getContentProvider() {
        return this.internalGetContentProvider();
    }

    protected final ConcurrentTreeContentProvider internalGetContentProvider() {
        if (this.provider == null) {
            this.provider = new ConcurrentTreeContentProvider(this.getTreeProvider(), (Object)Messages.TreeProviderDomain_1, false);
            this.provider.useTreePaths(true);
            this.provider.setRootPath(new IParentProvider(){

                public Object getParent(Object child) {
                    if (child instanceof DomainSubtreeRoot) {
                        TreePath prefix = (TreePath)TreeProviderDomain.this.fTreePathPrefixes.get(child);
                        if (prefix == null) {
                            return null;
                        }
                        return prefix.getLastSegment();
                    }
                    Collection prefixes = TreeProviderDomain.this.fTreePathPrefixes.values();
                    if (prefixes == null) {
                        return null;
                    }
                    for (TreePath prefix : prefixes) {
                        int idx = 0;
                        while (idx < prefix.getSegmentCount()) {
                            if (prefix.getSegment(idx).equals(child)) {
                                if (idx == 0) {
                                    return null;
                                }
                                return prefix.getSegment(idx - 1);
                            }
                            ++idx;
                        }
                    }
                    return null;
                }
            });
        }
        return this.provider;
    }

    public final boolean contains(Object element) {
        if (element instanceof DomainSubtreeRoot) {
            DomainSubtreeRoot dsr = (DomainSubtreeRoot)element;
            return dsr.getDomain() == this;
        }
        if (element == this.getRoot()) {
            return true;
        }
        Object parent = this.internalGetContentProvider().getParent(element);
        return parent != null;
    }

    public abstract ViewerSorter getSorter();

    public void dispose() {
        if (this.provider != null) {
            this.provider.dispose();
            this.provider = null;
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        if (this.rq != null) {
            this.rq.dispose();
            this.rq = null;
        }
        super.dispose();
    }

    protected final IOperationRunner getOperationRunner() {
        if (this.rq == null) {
            IWorkbenchPart workbenchPart = this.getWorkbenchPart();
            this.rq = workbenchPart != null ? new PartSiteJobRunner(workbenchPart.getSite(), false) : new JobRunner(this.name, false);
        }
        return this.rq;
    }

    public boolean refresh(Object element) {
        element = this.convertToSelection(element);
        ConcurrentTreeContentProvider cp = this.internalGetContentProvider();
        ISetWithListeners swl = cp.getChildrenSet(element);
        IRefreshable refreshable = (IRefreshable)Adapters.getAdapter((Object)swl, IRefreshable.class);
        if (refreshable != null && refreshable.canRefresh()) {
            refreshable.refresh();
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.name = config.getAttribute("name");
    }
}

