/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.internal.rcp.ui.DeferredCheckBoxTreeViewer;
import com.ibm.team.process.internal.rcp.ui.ImagePool;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessAreaContentProvider;
import com.ibm.team.process.internal.rcp.ui.TeamAreaFiltersDialog;
import com.ibm.team.process.internal.rcp.ui.TeamRepositoryExceptionNode;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.utils.ItemHandleComparer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TeamAreaSelector
extends Composite {
    private IElementComparer fComparer;
    private ProcessAreaContentProvider fContentProvider;
    private boolean fIncludeArchived = false;
    private CheckboxTreeViewer fViewer;
    private Map fChangedProjectAreasToTeamAreasChanged = new HashMap();
    private Map fCurrentSelectedTeamAreas = null;
    private TeamAreaFiltersDialog fDialog;
    private ICheckStateListener fCheckStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            TeamAreaSelector.this.handleCheckStateChange(event.getElement(), event.getChecked());
        }
    };

    public TeamAreaSelector(TeamAreaFiltersDialog teamAreaFiltersDialog, Composite parent) {
        super(parent, 0);
        this.fDialog = teamAreaFiltersDialog;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.widthHint = 300;
        gridData.heightHint = 300;
        this.setLayoutData(gridData);
        Tree tree = new Tree((Composite)this, 2084);
        tree.setLayoutData((Object)gridData);
        this.fViewer = new DeferredCheckBoxTreeViewer(tree, this);
        this.fViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fViewer.setComparer(this.getComparer());
        this.fViewer.setComparator(new ViewerComparator());
        this.fViewer.setInput((Object)ConnectedProjectAreaRegistry.getDefault());
        this.fViewer.addCheckStateListener(this.fCheckStateListener);
    }

    private ITreeContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new ProcessAreaContentProvider();
            this.fContentProvider.setIncludeArchived(this.fIncludeArchived);
        }
        return this.fContentProvider;
    }

    private ILabelProvider getLabelProvider() {
        LabelProvider provider = new LabelProvider(null, (IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        provider.addListener(new LabelProviderListener());
        return provider;
    }

    public CheckboxTreeViewer getViewer() {
        return this.fViewer;
    }

    private IElementComparer getComparer() {
        if (this.fComparer == null) {
            this.fComparer = new ItemHandleComparer();
        }
        return this.fComparer;
    }

    public Map getChangedProjectAreas() {
        return this.fChangedProjectAreasToTeamAreasChanged;
    }

    public void selectAll(boolean state) {
        this.getViewer().setAllChecked(state);
    }

    public void setIncludeArchived(boolean includeArchived) {
        this.fIncludeArchived = includeArchived;
        if (this.fContentProvider != null) {
            this.fContentProvider.setIncludeArchived(includeArchived);
        }
    }

    public void updateCheckedState(Object element) {
        if (this.fCurrentSelectedTeamAreas == null) {
            this.fCurrentSelectedTeamAreas = new HashMap();
            this.updateCurrentSelectedTeamAreas();
        }
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        if (element instanceof IProjectAreaHandle) {
            IProjectAreaHandle connectedProjectArea = (IProjectAreaHandle)element;
            IItemManager itemManager = ((ITeamRepository)connectedProjectArea.getOrigin()).itemManager();
            IProjectArea projectArea = (IProjectArea)itemManager.getSharedItemIfKnown((IItemHandle)connectedProjectArea);
            if (projectArea != null) {
                boolean allSelected;
                List selectedTeamAreas = (List)this.fCurrentSelectedTeamAreas.get(this.getUniqueKey(connectedProjectArea));
                int numberOfSelectedTeamAreas = selectedTeamAreas == null ? 0 : selectedTeamAreas.size();
                boolean bl = allSelected = projectArea.getTeamAreas().size() == numberOfSelectedTeamAreas;
                if (allSelected) {
                    this.fViewer.setGrayed((Object)projectArea, false);
                    this.fViewer.setChecked((Object)projectArea, allSelected);
                } else {
                    this.fViewer.setGrayChecked((Object)projectArea, numberOfSelectedTeamAreas > 0);
                }
            }
        } else if (element instanceof ITeamArea) {
            ITeamArea teamArea = (ITeamArea)element;
            IProjectArea projectArea = registry.getConnectedProjectArea((ITeamAreaHandle)teamArea);
            ITeamAreaHierarchy teamAreaHierarchy = projectArea.getTeamAreaHierarchy();
            List originalOfSelectedTeamAreas = (List)this.fCurrentSelectedTeamAreas.get(this.getUniqueKey(projectArea));
            ArrayList selectedTeamAreas = originalOfSelectedTeamAreas == null ? new ArrayList() : new ArrayList(originalOfSelectedTeamAreas);
            boolean found = false;
            ItemHandleComparer itemHandleComparer = new ItemHandleComparer();
            for (ITeamAreaHandle selectedTeamArea : selectedTeamAreas) {
                if (!itemHandleComparer.equals((Object)selectedTeamArea, (Object)teamArea)) continue;
                if (this.fViewer.getExpandedState(this.fContentProvider.getParent(teamArea))) {
                    this.fViewer.setGrayed((Object)teamArea, false);
                    this.fViewer.setChecked((Object)teamArea, true);
                }
                found = true;
                break;
            }
            if (!found && this.fViewer.getExpandedState(this.fContentProvider.getParent(teamArea))) {
                this.fViewer.setGrayChecked((Object)teamArea, this.matchOnChildren(selectedTeamAreas, (ITeamAreaHandle)teamArea, teamAreaHierarchy));
            }
        }
        this.updateDescription();
    }

    private void updateCheckedStates(Object parent) {
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        if (parent == null) {
            List connectedProjectAreas = registry.getConnectedProjectAreas(null);
            for (IProjectAreaHandle connectedProjectArea : connectedProjectAreas) {
                boolean allSelected;
                IItemManager itemManager = ((ITeamRepository)connectedProjectArea.getOrigin()).itemManager();
                IProjectArea projectArea = (IProjectArea)itemManager.getSharedItemIfKnown((IItemHandle)connectedProjectArea);
                if (projectArea == null) continue;
                List selectedTeamAreas = (List)this.fCurrentSelectedTeamAreas.get(this.getUniqueKey(connectedProjectArea));
                boolean bl = allSelected = projectArea.getTeamAreas().size() == selectedTeamAreas.size();
                if (allSelected) {
                    this.fViewer.setGrayed((Object)projectArea, false);
                    this.fViewer.setChecked((Object)projectArea, allSelected);
                    continue;
                }
                this.fViewer.setGrayChecked((Object)projectArea, selectedTeamAreas.size() != 0);
            }
        } else if (parent instanceof IProjectArea) {
            IProjectArea projectArea = (IProjectArea)parent;
            ITeamAreaHierarchy teamAreaHierarchy = projectArea.getTeamAreaHierarchy();
            ArrayList roots = new ArrayList(teamAreaHierarchy.getRoots());
            ArrayList selectedTeamAreas = new ArrayList((List)this.fCurrentSelectedTeamAreas.get(this.getUniqueKey(projectArea)));
            Iterator rootsIterator = roots.iterator();
            block1: while (rootsIterator.hasNext()) {
                ITeamAreaHandle root = (ITeamAreaHandle)rootsIterator.next();
                this.fViewer.setGrayChecked((Object)root, false);
                Iterator selected = selectedTeamAreas.iterator();
                while (selected.hasNext()) {
                    ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)selected.next();
                    if (!teamAreaHandle.sameItemId((IItemHandle)root)) continue;
                    this.fViewer.setGrayed((Object)root, false);
                    this.fViewer.setChecked((Object)root, true);
                    rootsIterator.remove();
                    selected.remove();
                    continue block1;
                }
            }
            for (ITeamAreaHandle root : roots) {
                if (selectedTeamAreas.isEmpty()) {
                    this.fViewer.setGrayChecked((Object)root, false);
                    continue;
                }
                Set children = teamAreaHierarchy.getChildren(root);
                if (children.isEmpty()) {
                    this.fViewer.setGrayChecked((Object)root, false);
                    continue;
                }
                this.fViewer.setGrayChecked((Object)root, this.matchOnChildren(selectedTeamAreas, root, teamAreaHierarchy));
            }
        } else {
            ITeamArea parentTeamArea = (ITeamArea)parent;
            this.fViewer.setGrayChecked((Object)parentTeamArea, false);
            IProjectArea projectArea = registry.getConnectedProjectArea((ITeamAreaHandle)parentTeamArea);
            ITeamAreaHierarchy teamAreaHierarchy = projectArea.getTeamAreaHierarchy();
            ArrayList selectedTeamAreas = new ArrayList((List)this.fCurrentSelectedTeamAreas.get(this.getUniqueKey(projectArea)));
            boolean found = false;
            for (ITeamAreaHandle selectedTeamArea : selectedTeamAreas) {
                if (!selectedTeamArea.sameItemId((IItemHandle)parentTeamArea)) continue;
                this.fViewer.setGrayed((Object)parentTeamArea, false);
                this.fViewer.setChecked((Object)parentTeamArea, true);
                found = true;
                break;
            }
            if (!found) {
                this.fViewer.setGrayChecked((Object)parentTeamArea, this.matchOnChildren(selectedTeamAreas, (ITeamAreaHandle)parentTeamArea, teamAreaHierarchy));
            }
            selectedTeamAreas = new ArrayList((List)this.fCurrentSelectedTeamAreas.get(this.getUniqueKey(projectArea)));
            ArrayList newChildren = new ArrayList(teamAreaHierarchy.getChildren((ITeamAreaHandle)parentTeamArea));
            for (ITeamAreaHandle childTeamArea : newChildren) {
                this.fViewer.setGrayChecked((Object)childTeamArea, false);
                found = false;
                Iterator selected = selectedTeamAreas.iterator();
                while (selected.hasNext()) {
                    ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)selected.next();
                    if (!childTeamArea.sameItemId((IItemHandle)teamAreaHandle)) continue;
                    if (this.fViewer.getExpandedState(this.fContentProvider.getParent(parentTeamArea))) {
                        this.fViewer.setChecked((Object)childTeamArea, true);
                    }
                    selected.remove();
                    found = true;
                    break;
                }
                if (found || !this.fViewer.getExpandedState(this.fContentProvider.getParent(parentTeamArea))) continue;
                this.fViewer.setGrayChecked((Object)childTeamArea, this.matchOnChildren(selectedTeamAreas, childTeamArea, teamAreaHierarchy));
            }
        }
        this.updateDescription();
    }

    private void updateDescription() {
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        List connectedProjectAreas = registry.getConnectedProjectAreas(null);
        int totalCount = 0;
        int selectedCount = 0;
        for (IProjectAreaHandle connectedProjectAreaHandle : connectedProjectAreas) {
            IItemManager itemManager = ((ITeamRepository)connectedProjectAreaHandle.getOrigin()).itemManager();
            IProjectArea projectArea = (IProjectArea)itemManager.getSharedItemIfKnown((IItemHandle)connectedProjectAreaHandle);
            if (projectArea == null) continue;
            totalCount += projectArea.getTeamAreas().size();
            List selected = (List)this.fCurrentSelectedTeamAreas.get(this.getUniqueKey(connectedProjectAreaHandle));
            if (selected == null) continue;
            selectedCount += selected.size();
        }
        String description = NLS.bind((String)Messages.TeamAreaSelector_0, (Object)Integer.toString(selectedCount), (Object)Integer.toString(totalCount));
        this.fDialog.updateDescription(description);
    }

    private boolean matchOnChildren(List selectedTeamAreas, ITeamAreaHandle parentTeamArea, ITeamAreaHierarchy teamAreaHierarchy) {
        if (selectedTeamAreas.isEmpty()) {
            return false;
        }
        Set children = teamAreaHierarchy.getChildren(parentTeamArea);
        if (children.isEmpty()) {
            return false;
        }
        Iterator selected = selectedTeamAreas.iterator();
        while (selected.hasNext()) {
            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)selected.next();
            for (ITeamAreaHandle child : children) {
                if (child.sameItemId((IItemHandle)teamAreaHandle)) {
                    selected.remove();
                    return true;
                }
                if (!this.matchOnChildren(selectedTeamAreas, child, teamAreaHierarchy)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateCurrentSelectedTeamAreas() {
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        List connectedProjectAreas = registry.getConnectedProjectAreas(null);
        for (IProjectAreaHandle connectedProjectArea : connectedProjectAreas) {
            HashMap changedTeamAreaToSelectedState = (HashMap)this.fChangedProjectAreasToTeamAreasChanged.get(this.getUniqueKey(connectedProjectArea));
            List selectedTeamAreas = registry.getSelectedTeamAreas(connectedProjectArea);
            if (changedTeamAreaToSelectedState != null) {
                changedTeamAreaToSelectedState = new HashMap(changedTeamAreaToSelectedState);
                Iterator selected = selectedTeamAreas.iterator();
                while (selected.hasNext()) {
                    ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)selected.next();
                    Boolean change = (Boolean)changedTeamAreaToSelectedState.remove(teamAreaHandle.getItemId());
                    if (change == null || change.booleanValue()) continue;
                    selected.remove();
                }
                Set newlySelected = changedTeamAreaToSelectedState.entrySet();
                for (Map.Entry newSelect : newlySelected) {
                    if (!((Boolean)newSelect.getValue()).booleanValue()) continue;
                    selectedTeamAreas.add(ITeamArea.ITEM_TYPE.createItemHandle((UUID)newSelect.getKey(), null));
                }
            }
            this.fCurrentSelectedTeamAreas.put(this.getUniqueKey(connectedProjectArea), selectedTeamAreas);
        }
    }

    private void projectAreaChecked(boolean checked, IProjectArea projectArea) {
        List teamAreas;
        if (this.fViewer.getExpandedState((Object)projectArea)) {
            teamAreas = projectArea.getTeamAreas();
            Iterator iterator = teamAreas.iterator();
            while (iterator.hasNext()) {
                this.fViewer.setGrayed(iterator.next(), false);
            }
            this.fViewer.setSubtreeChecked((Object)projectArea, checked);
        } else {
            this.fViewer.setChecked((Object)projectArea, checked);
        }
        teamAreas = projectArea.getTeamAreas();
        HashMap<UUID, Boolean> changedTeamAreaToSelected = (HashMap<UUID, Boolean>)this.fChangedProjectAreasToTeamAreasChanged.get(this.getUniqueKey(projectArea));
        if (changedTeamAreaToSelected == null) {
            changedTeamAreaToSelected = new HashMap<UUID, Boolean>();
            this.fChangedProjectAreasToTeamAreasChanged.put(this.getUniqueKey(projectArea), changedTeamAreaToSelected);
        }
        for (ITeamAreaHandle teamArea : teamAreas) {
            changedTeamAreaToSelected.put(teamArea.getItemId(), checked);
        }
        this.updateCurrentSelectedTeamAreas();
        this.updateDescription();
    }

    public void projectAreasChecked(boolean checked) {
        this.fViewer.setGrayedElements(new Object[0]);
        TreeItem[] roots = this.fViewer.getTree().getItems();
        int i = 0;
        while (i < roots.length) {
            TreeItem treeItem = roots[i];
            Object item = treeItem.getData();
            if (item instanceof IProjectArea) {
                this.projectAreaChecked(checked, (IProjectArea)item);
            }
            ++i;
        }
    }

    public void handleCheckStateChange(Object element, boolean checked) {
        if (this.fViewer.getGrayed(element)) {
            checked = true;
        }
        this.fViewer.setGrayed(element, false);
        if (element instanceof IProjectArea) {
            this.projectAreaChecked(checked, (IProjectArea)element);
        } else if (element instanceof ITeamArea) {
            ITeamArea teamArea = (ITeamArea)element;
            String uniqueKey = this.getUniqueKey(teamArea.getProjectArea());
            HashMap<UUID, Boolean> changedTeamAreaToSelected = (HashMap<UUID, Boolean>)this.fChangedProjectAreasToTeamAreasChanged.get(uniqueKey);
            if (changedTeamAreaToSelected == null) {
                changedTeamAreaToSelected = new HashMap<UUID, Boolean>();
                this.fChangedProjectAreasToTeamAreasChanged.put(uniqueKey, changedTeamAreaToSelected);
            }
            changedTeamAreaToSelected.put(teamArea.getItemId(), checked);
            this.updateCurrentSelectedTeamAreas();
            Object parent = teamArea;
            while (parent != null) {
                this.updateCheckedStates(parent);
                parent = this.fContentProvider.getParent(parent);
            }
            this.updateCheckedStates(null);
        }
    }

    protected String getUniqueKey(Object element) {
        String uniqueKey = null;
        if (element instanceof IProcessAreaHandle) {
            IProcessAreaHandle handle = (IProcessAreaHandle)element;
            ITeamRepository repository = (ITeamRepository)handle.getOrigin();
            uniqueKey = repository.getId() + handle.getItemId().getUuidValue();
        }
        return uniqueKey;
    }

    private static class LabelProvider
    extends StandardLabelProvider
    implements IColorProvider,
    IFontProvider {
        public LabelProvider(ILabelProvider fallBackLabelProvider, IElementRemovedNotifier notifier) {
            super(fallBackLabelProvider, notifier);
        }

        public Color getBackground(Object element) {
            ViewerLabel label = new ViewerLabel(null, null);
            this.updateLabel(label, new TreePath(new Object[]{element}));
            return label.getBackground();
        }

        public Color getForeground(Object element) {
            ViewerLabel label = new ViewerLabel(null, null);
            this.updateLabel(label, new TreePath(new Object[]{element}));
            return label.getForeground();
        }

        public Font getFont(Object element) {
            ViewerLabel label = new ViewerLabel(null, null);
            this.updateLabel(label, new TreePath(new Object[]{element}));
            return label.getFont();
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof TeamRepositoryExceptionNode) {
                label.setText(((TeamRepositoryExceptionNode)element).getMessage());
                label.setImage(this.getResources().createImageWithDefault(ImagePool.ERROR_TICK));
            } else {
                super.updateLabel(label, element);
            }
        }
    }

    private class LabelProviderListener
    implements ILabelProviderListener {
        private LabelProviderListener() {
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] elements = event.getElements();
            if (elements != null) {
                int i = 0;
                while (i < elements.length) {
                    Object element = elements[i];
                    TeamAreaSelector.this.fViewer.update(element, null);
                    ++i;
                }
            }
        }
    }
}

