/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.TeamAreaSelector;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.common.UUID;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class TeamAreaFiltersDialog
extends Dialog {
    private TeamAreaSelector fSelector;
    private Label fDescription;

    public TeamAreaFiltersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.TeamAreaFiltersDialog_0);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).applyTo(composite);
        composite.setLayoutData((Object)new GridData(1808));
        this.fDescription = new Label(composite, 64);
        this.fDescription.setLayoutData((Object)new GridData(768));
        this.fSelector = new TeamAreaSelector(this, composite);
        this.fSelector.setIncludeArchived(ProcessRCPUIPlugin.getDefault().getPluginPreferenceStore().getBoolean("teamArtifactsNavigator.showArchived"));
        Composite buttonBar = new Composite(composite, 0);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo(buttonBar);
        Button selectAll = new Button(buttonBar, 8);
        selectAll.setText(Messages.TeamAreaFiltersDialog_1);
        this.setButtonLayoutData(selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamAreaFiltersDialog.this.fSelector.selectAll(true);
            }
        });
        Button deselectAll = new Button(buttonBar, 8);
        deselectAll.setText(Messages.TeamAreaFiltersDialog_2);
        this.setButtonLayoutData(deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamAreaFiltersDialog.this.fSelector.selectAll(false);
            }
        });
        this.fSelector.forceFocus();
        composite.layout();
        TeamAreaFiltersDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        Map changedProjectAreas = this.fSelector.getChangedProjectAreas();
        if (!changedProjectAreas.isEmpty()) {
            ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
            List connectedProjectAreas = registry.getConnectedProjectAreas(null);
            for (IProjectAreaHandle projectAreaHandle : connectedProjectAreas) {
                String uniqueKey = this.fSelector.getUniqueKey(projectAreaHandle);
                Map changedTeamAreasToSelected = (Map)changedProjectAreas.get(uniqueKey);
                if (changedTeamAreasToSelected == null) continue;
                this.updateSelectedTeamAreas(changedTeamAreasToSelected, projectAreaHandle);
            }
        }
        super.okPressed();
    }

    private void updateSelectedTeamAreas(Map changedTeamAreasToSelected, IProjectAreaHandle projectAreaHandle) {
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        List selectedTeamAreas = registry.getSelectedTeamAreas(projectAreaHandle);
        Iterator currentlySelected = selectedTeamAreas.iterator();
        while (currentlySelected.hasNext()) {
            ITeamAreaHandle selected = (ITeamAreaHandle)currentlySelected.next();
            UUID selectedUUID = selected.getItemId();
            Boolean selectedState = (Boolean)changedTeamAreasToSelected.remove(selectedUUID);
            if (selectedState == null || selectedState.booleanValue()) continue;
            currentlySelected.remove();
            if (changedTeamAreasToSelected.isEmpty()) break;
        }
        if (!changedTeamAreasToSelected.isEmpty()) {
            Set changedTeamAreasEntries = changedTeamAreasToSelected.entrySet();
            for (Map.Entry changedEntry : changedTeamAreasEntries) {
                Boolean selected = (Boolean)changedEntry.getValue();
                if (!selected.booleanValue()) continue;
                ITeamAreaHandle handle = (ITeamAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle((UUID)changedEntry.getKey(), null);
                selectedTeamAreas.add(handle);
            }
        }
        registry.setSelectedTeamAreas(projectAreaHandle, selectedTeamAreas);
    }

    public void updateDescription(String description) {
        this.fDescription.setText(description);
        this.fDescription.getParent().layout();
    }

    protected TeamAreaSelector getTeamAreaSelector() {
        return this.fSelector;
    }
}

