/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.internal.rcp.ui.AbstractLicensePropertyPage;
import com.ibm.team.process.internal.rcp.ui.LicenseAdminLibrary;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.RepositoryUtil;
import com.ibm.team.repository.common.ILicenseType;
import com.ibm.team.repository.common.IServerLicenseType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class ServerLicensePropertyPage
extends AbstractLicensePropertyPage {
    private ITeamRepository fTeamRepository;
    private Composite fComposite;
    private Job fJob;
    private IServerLicenseType fServerLicense;
    private Link fPurchaseURLLink;
    private Label fDescriptionLabel;
    private Label fNameLabel;
    private Label fLicenseKey;
    private Label fEditionLabel;
    private Label fVersionLabel;
    private Label fBuildIdLabel;
    private String fBuildId;
    private String fVersion;

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        this.fTeamRepository = (ITeamRepository)element.getAdapter(ITeamRepository.class);
        if (this.fTeamRepository == null && element instanceof IProjectArea) {
            this.fTeamRepository = (ITeamRepository)((IProjectArea)element).getOrigin();
        }
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)new GridLayout(1, false));
        this.fComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.verticalSpacing = 5;
        this.fComposite.setLayout((Layout)layout);
        Label label = new Label(this.fComposite, 0);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        label.setText(Messages.ServerLicensePropertyPage_0);
        this.fNameLabel = new Label(this.fComposite, 64);
        this.fNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(this.fComposite, 0);
        label.setText(Messages.ServerLicensePropertyPage_17);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fVersionLabel = new Label(this.fComposite, 64);
        this.fVersionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(this.fComposite, 0);
        label.setText(Messages.ServerLicensePropertyPage_15);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fEditionLabel = new Label(this.fComposite, 64);
        this.fEditionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(this.fComposite, 0);
        label.setText(Messages.ServerLicensePropertyPage_1);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fDescriptionLabel = new Label(this.fComposite, 64);
        this.fDescriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(this.fComposite, 0);
        label.setText(Messages.ServerLicensePropertyPage_18);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fBuildIdLabel = new Label(this.fComposite, 64);
        this.fBuildIdLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(this.fComposite, 0);
        label.setText(Messages.ServerLicensePropertyPage_8);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fLicenseKey = new Label(this.fComposite, 64);
        this.fLicenseKey.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(this.fComposite, 0);
        this.fPurchaseURLLink = this.createPurchaseURL(this.fComposite);
        this.intialize();
        this.applyDialogFont(this.fComposite);
        return this.fComposite;
    }

    private void intialize() {
        if (!this.fTeamRepository.loggedIn() || this.fTeamRepository.getErrorState() != 0) {
            this.setStatus((IStatus)new Status(2, "com.ibm.team.process.rcp.ui", Messages.ServerLicensePropertyPage_14));
            return;
        }
        this.fJob = new Job(Messages.ServerLicensePropertyPage_4){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.ServerLicensePropertyPage_19, 1000);
                    ServerLicensePropertyPage.this.fetchServerLicense(ServerLicensePropertyPage.this.fTeamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
                    ServerLicensePropertyPage.this.fetchServerInformation(ServerLicensePropertyPage.this.fTeamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 700));
                    ServerLicensePropertyPage.this.asyncExec((Control)ServerLicensePropertyPage.this.fNameLabel, new Runnable(){

                        public void run() {
                            ServerLicensePropertyPage.this.update();
                        }
                    });
                }
                catch (TeamRepositoryException e) {
                    ServerLicensePropertyPage.this.asyncExec((Control)ServerLicensePropertyPage.this.fNameLabel, new Runnable(){

                        public void run() {
                            ServerLicensePropertyPage.this.setStatus((IStatus)new Status(4, "com.ibm.team.process.rcp.ui", Messages.ServerLicensePropertyPage_5, (Throwable)e));
                        }
                    });
                }
                ServerLicensePropertyPage.this.fJob = null;
                return Status.OK_STATUS;
            }
        };
        this.fJob.schedule();
    }

    protected void fetchServerInformation(ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        this.fBuildId = RepositoryUtil.getRepositoryBuildId((ITeamRepository)teamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
        this.fVersion = RepositoryUtil.getRepositoryVersion((ITeamRepository)teamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
    }

    private void update() {
        this.fNameLabel.setText(ServerLicensePropertyPage.normalize(this.fServerLicense.getProductName()));
        this.fEditionLabel.setText(ServerLicensePropertyPage.normalize(this.fServerLicense.getEditionName()));
        this.fDescriptionLabel.setText(ServerLicensePropertyPage.normalize(this.fServerLicense.getDescription()));
        this.fBuildIdLabel.setText(this.fBuildId);
        this.fVersionLabel.setText(this.fVersion);
        Date expirationTime = this.fServerLicense.getExpirationTime();
        String status = expirationTime == null ? Messages.ServerLicensePropertyPage_10 : (expirationTime.after(new Date(System.currentTimeMillis())) ? NLS.bind((String)Messages.ServerLicensePropertyPage_11, (Object)DateFormat.getDateInstance((int)1).format(expirationTime)) : NLS.bind((String)Messages.ServerLicensePropertyPage_12, (Object)DateFormat.getDateInstance((int)1).format(expirationTime)));
        this.fLicenseKey.setText(status);
        String buyURL = this.fServerLicense.getBuyURL();
        if (buyURL != null) {
            String linkText = NLS.bind((String)Messages.ServerLicensePropertyPage_16, (Object)this.fServerLicense.getProductName());
            this.fPurchaseURLLink.setText(NLS.bind((String)"<a>{0}</a>", (Object)linkText));
            this.fPurchaseURL = buyURL;
        }
        this.fComposite.layout(true);
    }

    private static String normalize(String text) {
        return text == null ? "" : text;
    }

    private void fetchServerLicense(ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        LicenseAdminLibrary adminLibrary = new LicenseAdminLibrary(teamRepository);
        this.fServerLicense = adminLibrary.getServerLicenseType(monitor);
    }

    protected ILicenseType getLicense() {
        return this.fServerLicense;
    }
}

