/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.RepositoryInfo;
import com.ibm.team.process.rcp.ui.IStatusHandler;
import com.ibm.team.process.rcp.ui.RepositoryCreationPart;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.utils.PasswordUtil;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class RepositoryPropertyPage
extends PropertyPage
implements IStatusHandler {
    private RepositoryCreationPart fPart;
    private RepositoryInfo fRepositoryInformation;
    private Composite fComposite;

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        ITeamRepository repo = (ITeamRepository)element.getAdapter(ITeamRepository.class);
        this.fRepositoryInformation = new RepositoryInfo(repo);
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)new GridLayout(1, false));
        this.fComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fPart = new RepositoryCreationPart(this, this.fRepositoryInformation);
        return this.fComposite;
    }

    public void dispose() {
        if (this.fPart != null) {
            this.fPart.dispose();
        }
    }

    public boolean performOk() {
        Job saveJob = new Job(Messages.RepositoryPropertyPage_0){

            protected IStatus run(IProgressMonitor monitor) {
                RepositoryPropertyPage.this.save(monitor);
                return Status.OK_STATUS;
            }
        };
        saveJob.setUser(true);
        saveJob.schedule();
        return true;
    }

    private void save(IProgressMonitor monitor) {
        boolean needsReset = false;
        if (!this.fRepositoryInformation.fTeamRepository.getRepositoryURI().equalsIgnoreCase(this.fRepositoryInformation.fURI)) {
            TeamPlatform.getTeamRepositoryService().removeTeamRepository(this.fRepositoryInformation.fTeamRepository);
            this.fRepositoryInformation.fTeamRepository = this.createNewRepository(this.fRepositoryInformation.fURI, monitor);
        }
        if (!this.fRepositoryInformation.fUserID.equals(this.fRepositoryInformation.fTeamRepository.getUserId())) {
            needsReset = true;
        }
        if (!PasswordUtil.getSavedPassword((ITeamRepository)this.fRepositoryInformation.fTeamRepository, (String)this.fRepositoryInformation.fUserID).equals(this.fRepositoryInformation.fPassword)) {
            needsReset = true;
        }
        this.fRepositoryInformation.fTeamRepository.setAutoLogin(this.fRepositoryInformation.fAutoLogin);
        this.fRepositoryInformation.fTeamRepository.setSavePassword(this.fRepositoryInformation.fSavePassword);
        this.fRepositoryInformation.fTeamRepository.setName(this.fRepositoryInformation.fName);
        this.fRepositoryInformation.fTeamRepository.setUserId(this.fRepositoryInformation.fUserID);
        if (this.fRepositoryInformation.fTeamRepository.getSavePassword()) {
            PasswordUtil.savePassword((ITeamRepository)this.fRepositoryInformation.fTeamRepository, (String)this.fRepositoryInformation.fUserID, (String)this.fRepositoryInformation.fPassword);
        } else {
            PasswordUtil.clearSavedPassword((ITeamRepository)this.fRepositoryInformation.fTeamRepository);
        }
        this.fRepositoryInformation.fTeamRepository.setConnectionTimeout(this.fRepositoryInformation.fTimeout);
        if (needsReset) {
            try {
                if (this.fRepositoryInformation.fTeamRepository.loggedIn()) {
                    this.fRepositoryInformation.fTeamRepository.logout();
                }
                this.fRepositoryInformation.fTeamRepository.login(monitor);
            }
            catch (TeamRepositoryException teamRepositoryException) {
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    private ITeamRepository createNewRepository(String uri, IProgressMonitor monitor) {
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(uri);
        TeamPlatform.getTeamRepositoryService().addTeamRepository(repo);
        return repo;
    }

    public void setStatus(IStatus status) {
        String statusMessage = null;
        if (status != null && !status.isOK()) {
            statusMessage = status.getMessage();
        }
        if (statusMessage == null) {
            this.setMessage(null);
        } else {
            this.setMessage(statusMessage, 3);
        }
        this.setValid(statusMessage == null);
    }

    public Composite getComposite() {
        return this.fComposite;
    }

    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }
}

