/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.RepositoryDomain;
import com.ibm.team.process.internal.rcp.ui.RepositoryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class RepositoryDomainContentProvider
implements ITreePathContentProvider {
    private RepositoryDomain fRepositoryDomain;
    private TreeViewer fViewer;
    private ITeamRepositoryService fService;
    private RepositoryListener fRepositoryListener;
    private ITeamRepositoryService.IRepositoryServiceListener fListener;

    public RepositoryDomainContentProvider(RepositoryDomain repositoryDomain) {
        this.fRepositoryListener = new RepositoryListener((StructuredViewer)this.fViewer, new String[]{"name"}, false);
        this.fListener = new ITeamRepositoryService.IRepositoryServiceListener(){

            public void removedRepository(final ITeamRepository repository) {
                RepositoryDomainContentProvider.this.updateViewer(new Runnable(){

                    public void run() {
                        if (RepositoryDomainContentProvider.this.fViewer != null) {
                            RepositoryDomainContentProvider.this.fViewer.remove((Object)RepositoryDomainContentProvider.this.fRepositoryDomain, new Object[]{repository});
                        }
                    }
                });
            }

            public void addedRepository(final ITeamRepository repository) {
                RepositoryDomainContentProvider.this.updateViewer(new Runnable(){

                    public void run() {
                        if (RepositoryDomainContentProvider.this.fViewer != null) {
                            RepositoryDomainContentProvider.this.fViewer.expandToLevel((Object)RepositoryDomainContentProvider.this.fRepositoryDomain, 1);
                            RepositoryDomainContentProvider.this.fViewer.add((Object)RepositoryDomainContentProvider.this.fRepositoryDomain, (Object)repository);
                            RepositoryDomainContentProvider.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)repository), true);
                        }
                    }
                });
            }
        };
        this.fRepositoryDomain = repositoryDomain;
        this.fService = TeamPlatform.getTeamRepositoryService();
        this.fService.addRepositoryServiceListener(this.fListener);
    }

    public Object[] getElements(Object inputElement) {
        Object[] repositories = this.fService.getTeamRepositories();
        int i = 0;
        while (i < repositories.length) {
            Object teamRepository = repositories[i];
            teamRepository.addGenericListener((Object)"name", (IListener)this.fRepositoryListener);
            ++i;
        }
        return repositories;
    }

    public void dispose() {
        if (this.fService != null) {
            this.fService.removeRepositoryServiceListener(this.fListener);
            this.fService = null;
        }
        if (this.fRepositoryListener != null) {
            this.fRepositoryListener.dispose();
            this.fRepositoryListener = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
    }

    public Object[] getChildren(TreePath parentPath) {
        Object parentElement = parentPath.getLastSegment();
        if (parentElement == this.fRepositoryDomain) {
            return this.getElements(parentElement);
        }
        return new Object[0];
    }

    public TreePath[] getParents(Object element) {
        return new TreePath[0];
    }

    public boolean hasChildren(TreePath path) {
        Object element = path.getLastSegment();
        return element == this.fRepositoryDomain && this.fService.getTeamRepositories().length > 0;
    }

    private void updateViewer(Runnable runnable) {
        Control control;
        if (this.fViewer != null && (control = this.fViewer.getControl()) != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(runnable);
        }
    }
}

