/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.rcp.ui.LicenseAdminLibrary;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.RepositoryLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IServerLicenseType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LoginAction
extends Action
implements IObjectActionDelegate {
    private static final int SERVER_EXPIRATION_THRESHOLD = 15;
    private IStructuredSelection fSelection;
    private IWorkbenchPart fTargetPart;

    public LoginAction(IStructuredSelection selection) {
        super(Messages.LoginAction_0);
        this.fSelection = selection;
    }

    public LoginAction() {
    }

    public void run() {
        Iterator selection = this.fSelection.iterator();
        ArrayList<Object> teamRepositories = new ArrayList<Object>();
        while (selection.hasNext()) {
            Object next = selection.next();
            if (next instanceof IProjectAreaHandle) {
                IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)next;
                teamRepositories.add(projectAreaHandle.getOrigin());
                continue;
            }
            teamRepositories.add(next);
        }
        this.login(this.fTargetPart, teamRepositories);
    }

    private void login(final IWorkbenchPart targetPart, List teamRepositories) {
        for (final ITeamRepository repo : teamRepositories) {
            String jobName = NLS.bind((String)Messages.LoginAction_1, (Object)RepositoryLabelProvider.getRepositoryText(repo));
            Job loginJob = new Job(jobName){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(NLS.bind((String)Messages.LoginAction_2, (Object)RepositoryLabelProvider.getRepositoryText(repo)), 1000);
                        repo.login((IProgressMonitor)new SubProgressMonitor(monitor, 950));
                        if (targetPart != null) {
                            LoginAction.this.checkServerLicenseExpiration(targetPart, repo, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        LoginAction.this.reportLoginException(targetPart, e, repo);
                    }
                    return Status.OK_STATUS;
                }
            };
            if (targetPart != null) {
                loginJob.setUser(true);
            }
            loginJob.schedule();
        }
    }

    public void reportLoginException(final IWorkbenchPart targetPart, final TeamRepositoryException exception, final ITeamRepository repo) {
        this.asyncExec(targetPart, new Runnable(){

            public void run() {
                String message = RepositoryLabelProvider.toConnectionErrorString(exception, repo);
                ErrorDialog.openError((Shell)LoginAction.this.getShell(targetPart), (String)Messages.LoginAction_3, null, (IStatus)new Status(4, "com.ibm.team.process.rcp.ui", message, (Throwable)exception));
            }
        });
        ProcessRCPUIPlugin.getDefault().log(exception);
    }

    public static void runHeadless(List repos) {
        new LoginAction().loginHeadless(repos);
    }

    private void loginHeadless(List repos) {
        this.login(null, repos);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = (IStructuredSelection)selection;
        action.setEnabled(this.isEnabled(this.fSelection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        for (ITeamRepository next : selection) {
            int state = next.getState();
            int errorState = next.getErrorState();
            if (state != 3 && errorState == 0) continue;
            return true;
        }
        return false;
    }

    private Shell getShell(IWorkbenchPart targetPart) {
        Display display;
        Shell shell = null;
        if (targetPart != null) {
            shell = targetPart.getSite().getShell();
        }
        if (shell == null || shell.isDisposed()) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                window = windows[0];
            }
            if (window != null) {
                shell = window.getShell();
            }
        }
        if ((shell == null || shell.isDisposed()) && (display = Display.getCurrent()) != null) {
            shell = display.getActiveShell();
        }
        return shell;
    }

    private void checkServerLicenseExpiration(final IWorkbenchPart targetPart, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        long millisPerDay;
        LicenseAdminLibrary adminLibrary = new LicenseAdminLibrary(repo);
        IServerLicenseType serverLicense = adminLibrary.getServerLicenseType(monitor);
        Date expirationDate = serverLicense.getExpirationTime();
        Date currentTime = new Date();
        if (expirationDate == null || expirationDate.before(currentTime)) {
            return;
        }
        long millisToExpiration = expirationDate.getTime() - currentTime.getTime();
        int daysLeft = (int)Math.ceil((double)millisToExpiration / (double)(millisPerDay = 86400000L));
        if (daysLeft > 15) {
            return;
        }
        final String message = daysLeft == 1 ? NLS.bind((String)Messages.LoginAction_5, (Object)RepositoryLabelProvider.getRepositoryText(repo)) : NLS.bind((String)Messages.LoginAction_6, (Object)RepositoryLabelProvider.getRepositoryText(repo), (Object)Integer.toString(daysLeft));
        this.asyncExec(targetPart, new Runnable(){

            public void run() {
                MessageDialog.openWarning((Shell)LoginAction.this.getShell(targetPart), (String)Messages.LoginAction_7, (String)message);
            }
        });
    }

    private void asyncExec(final IWorkbenchPart targetPart, final Runnable runnable) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    Shell shell = LoginAction.this.getShell(targetPart);
                    if (shell != null) {
                        runnable.run();
                    }
                }
            });
        }
    }
}

