/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.ImagePool;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.RepositoryInfo;
import com.ibm.team.process.internal.rcp.ui.RepositoryLoginHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

public class JazzAuthenticator
extends Authenticator {
    private static final String PASSWORD = "com.ibm.team.foundation.authentication.password";
    private static final String USERID = "com.ibm.team.foundation.authentication.userid";
    private static final String REALM = "";
    private static final String AUTHMETHOD = "Basic";
    private static JazzAuthenticator fgInstance;
    private ITeamRepository.ILoginHandler fLoginHandler = new RepositoryLoginHandler();
    private Set fAlreadyProvidedAuth = new HashSet();
    private Map fCachedRepositoryPasswords = new HashMap();

    private JazzAuthenticator() {
    }

    public static JazzAuthenticator getInstance() {
        if (fgInstance == null) {
            fgInstance = new JazzAuthenticator();
        }
        return fgInstance;
    }

    public static void setAuthenticator() {
        Authenticator.setDefault(JazzAuthenticator.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PasswordAuthentication getPasswordAuthentication() throws OperationCanceledException {
        final URL url = this.getRequestingURL();
        ITeamRepository teamRepository = JazzAuthenticator.getTeamRepository(url);
        if (teamRepository != null) {
            RepositoryInfo loginInfo;
            if (teamRepository.getSavePassword() && teamRepository.getErrorState() == 0) {
                loginInfo = new RepositoryInfo(teamRepository);
            } else {
                Map map = this.fCachedRepositoryPasswords;
                synchronized (map) {
                    ITeamRepository.ILoginHandler.ILoginInfo cachedLoginInfo = (ITeamRepository.ILoginHandler.ILoginInfo)this.fCachedRepositoryPasswords.get(teamRepository.getRepositoryURI());
                    loginInfo = teamRepository.loggedIn() && cachedLoginInfo != null && teamRepository.loggedInContributor().getUserId().equals(cachedLoginInfo.getUserId()) ? cachedLoginInfo : this.fLoginHandler.challenge(teamRepository);
                    if (loginInfo == null) {
                        this.fCachedRepositoryPasswords.remove(teamRepository.getRepositoryURI());
                        throw new OperationCanceledException(Messages.JazzAuthenticator_0);
                    }
                    this.fCachedRepositoryPasswords.put(teamRepository.getRepositoryURI(), loginInfo);
                }
            }
            return new PasswordAuthentication(loginInfo.getUserId(), loginInfo.getPassword().toCharArray());
        }
        Map authInfo = Platform.getAuthorizationInfo((URL)url, (String)REALM, (String)AUTHMETHOD);
        if (authInfo == null || authInfo.get(USERID) == null || ((String)authInfo.get(USERID)).length() <= 0 || authInfo.get(PASSWORD) == null || ((String)authInfo.get(PASSWORD)).length() <= 0 || this.fAlreadyProvidedAuth.contains(url)) {
            String password;
            String userId;
            if (authInfo == null) {
                userId = REALM;
                password = REALM;
            } else {
                userId = (String)authInfo.get(USERID);
                password = (String)authInfo.get(PASSWORD);
            }
            final PasswordAuthentication[] credentials = new PasswordAuthentication[1];
            UIJob job = new UIJob(Messages.JazzAuthenticator_3){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Shell activeShell = Display.getCurrent().getActiveShell();
                    CredentialsPromptDialog dialog = new CredentialsPromptDialog(activeShell, userId, password, url.toString(), JazzAuthenticator.this.getRequestingPrompt(), JazzAuthenticator.this.fAlreadyProvidedAuth.contains(url));
                    if (dialog.open() != 0) {
                        return Status.CANCEL_STATUS;
                    }
                    credentials[0] = new PasswordAuthentication(dialog.getUserid(), dialog.getPassword().toCharArray());
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
            if (job.getResult().equals(Status.CANCEL_STATUS)) {
                throw new OperationCanceledException(Messages.JazzAuthenticator_4);
            }
            if (credentials[0] != null) {
                HashMap<String, String> newInfo = new HashMap<String, String>();
                newInfo.put(USERID, credentials[0].getUserName());
                newInfo.put(PASSWORD, new String(credentials[0].getPassword()));
                try {
                    Platform.flushAuthorizationInfo((URL)url, (String)REALM, (String)AUTHMETHOD);
                    Platform.addAuthorizationInfo((URL)url, (String)REALM, (String)AUTHMETHOD, newInfo);
                }
                catch (CoreException e) {
                    ProcessRCPUIPlugin.getDefault().log(Messages.JazzAuthenticator_5, e);
                }
                this.fAlreadyProvidedAuth.remove(url);
                return credentials[0];
            }
        } else {
            this.fAlreadyProvidedAuth.add(url);
            return new PasswordAuthentication((String)authInfo.get(USERID), ((String)authInfo.get(PASSWORD)).toCharArray());
        }
        return null;
    }

    private static ITeamRepository getTeamRepository(URL url) {
        String protocol = url.getProtocol();
        if (protocol == null) {
            return null;
        }
        String authority = url.getAuthority();
        if (authority == null) {
            return null;
        }
        String path = url.getPath();
        if (path == null) {
            return null;
        }
        ITeamRepository teamRepository = null;
        try {
            Location location = Location.location((URI)new URI(url.toString()));
            teamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository(location.getRepoUri(), 4);
        }
        catch (TeamRepositoryException teamRepositoryException) {
        }
        catch (URISyntaxException uRISyntaxException) {}
        return teamRepository;
    }

    private static class CredentialsPromptDialog
    extends Dialog {
        private String fUrl;
        private String fMessage;
        private Text fUserText;
        private Text fPwdText;
        private String fUserid;
        private String fPassword;
        private boolean fIsError;

        public CredentialsPromptDialog(Shell parent, String userid, String password, String url, String message, boolean isError) {
            super(parent);
            this.fUrl = url;
            this.fMessage = message;
            this.fUserid = userid;
            this.fPassword = password;
            this.fIsError = isError;
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(Messages.JazzAuthenticator_6);
            super.configureShell(newShell);
        }

        protected Control createDialogArea(Composite parent) {
            Label msg;
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            Composite imageComposite = new Composite(composite, 0);
            imageComposite.setLayout((Layout)new GridLayout());
            imageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            Label imageLabel = new Label(imageComposite, 0);
            LocalResourceManager resourceMgr = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
            Image keyLockImage = resourceMgr.createImageWithDefault(ImagePool.KEYLOCK_IMAGE);
            imageLabel.setImage(keyLockImage);
            GridData data = new GridData(768);
            imageLabel.setLayoutData((Object)data);
            Composite main = new Composite(composite, 0);
            main.setLayout((Layout)new GridLayout(2, false));
            main.setLayoutData((Object)new GridData(4, 4, true, true));
            if (this.fIsError) {
                msg = new Label(main, 0);
                msg.setText(Messages.JazzAuthenticator_7);
                msg.setForeground(Display.getCurrent().getSystemColor(3));
                GridData msgData = new GridData(4, 4, true, true);
                msgData.horizontalSpan = 2;
                msg.setLayoutData((Object)msgData);
            }
            msg = new Label(main, 0);
            StringBuffer buf = new StringBuffer(this.fMessage);
            int maxWidth = this.convertWidthInCharsToPixels(Messages.JazzAuthenticator_8.length()) + this.convertHorizontalDLUsToPixels(200) + 5;
            int widthForElipsesAndClosing = this.convertWidthInCharsToPixels(4);
            int minWidthForHost = this.convertWidthInCharsToPixels(10);
            if (this.convertWidthInCharsToPixels(buf.length()) < maxWidth - minWidthForHost) {
                buf.append(" (");
                buf.append(this.fUrl);
                boolean entered = false;
                while (this.convertWidthInCharsToPixels(buf.length()) > maxWidth - widthForElipsesAndClosing) {
                    buf.deleteCharAt(buf.length() - 1);
                    entered = true;
                }
                if (entered) {
                    buf.append(Messages.JazzAuthenticator_14);
                }
                buf.append(")");
            }
            msg.setText(buf.toString());
            GridData msgData = new GridData(768);
            msgData.horizontalSpan = 2;
            msg.setLayoutData((Object)msgData);
            new Label(main, 0).setText(Messages.JazzAuthenticator_12);
            this.fUserText = new Text(main, 2052);
            GridData userData = new GridData(768);
            userData.widthHint = this.convertHorizontalDLUsToPixels(200);
            this.fUserText.setLayoutData((Object)userData);
            this.fUserText.setText(this.fUserid);
            new Label(main, 0).setText(Messages.JazzAuthenticator_13);
            this.fPwdText = new Text(main, 0x400800);
            GridData pwdData = new GridData(768);
            pwdData.widthHint = this.convertHorizontalDLUsToPixels(200);
            this.fPwdText.setLayoutData((Object)pwdData);
            this.fPwdText.setText(this.fPassword);
            CredentialsPromptDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void okPressed() {
            this.fUserid = this.fUserText.getText().trim();
            this.fPassword = this.fPwdText.getText().trim();
            super.okPressed();
        }

        public String getUserid() {
            return this.fUserid;
        }

        public String getPassword() {
            return this.fPassword;
        }
    }
}

