/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class HistoryCombo {
    private static final String PREF_HISTORY = "history";
    private static final int MAX_HISTORY_LENGTH = 10;
    private Combo fCombo;
    private Preferences fPreferences;

    public HistoryCombo(Composite parent, Preferences savedState, boolean autoSelect) {
        this(new Combo(parent, 2052), savedState, autoSelect);
    }

    public HistoryCombo(Combo combo, Preferences savedState, boolean autoSelect) {
        this.fCombo = combo;
        this.fPreferences = savedState;
        if (savedState != null) {
            this.loadState(combo, savedState);
        }
        if (combo.getItemCount() > 0 && autoSelect) {
            combo.select(0);
        }
    }

    public HistoryCombo(Combo toWrap, Preferences savedState) {
        this(toWrap, savedState, true);
    }

    private void loadState(Combo toWrap, Preferences savedState) {
        ArrayList<String> result = new ArrayList<String>();
        int idx = 0;
        while (true) {
            try {
                if (!savedState.nodeExists(PREF_HISTORY + idx)) break;
                Preferences child = savedState.node(PREF_HISTORY + idx);
                String next = child.get("value", "");
                result.add(next);
            }
            catch (BackingStoreException backingStoreException) {
                break;
            }
            ++idx;
        }
        toWrap.setItems(result.toArray(new String[result.size()]));
    }

    protected void reload() {
        this.loadState(this.fCombo, this.fPreferences);
    }

    public Combo getCombo() {
        return this.fCombo;
    }

    public Control getControl() {
        return this.fCombo;
    }

    public String[] getHistory() {
        return this.fCombo.getItems();
    }

    public void addToHistory(String toAdd, boolean updateControl) {
        String[] items = this.fCombo.getItems();
        ArrayList<String> newItems = new ArrayList<String>();
        newItems.add(toAdd);
        int toCopy = Math.min(items.length, 9);
        int i = 0;
        while (i < toCopy) {
            String next = items[i];
            if (!newItems.contains(next)) {
                newItems.add(next);
            }
            ++i;
        }
        String[] newItemsArray = newItems.toArray(new String[newItems.size()]);
        if (updateControl) {
            this.fCombo.setItems(newItemsArray);
        }
        try {
            this.save(this.fPreferences, newItemsArray);
            this.fPreferences.flush();
        }
        catch (BackingStoreException e) {
            ProcessRCPUIPlugin.getDefault().log(e);
        }
    }

    public void addToHistory() {
        this.addToHistory(this.fCombo.getText(), false);
    }

    private void save(Preferences whereToSave, String[] items) throws BackingStoreException {
        Preferences historyNode;
        if (whereToSave.nodeExists(PREF_HISTORY)) {
            historyNode = whereToSave.node(PREF_HISTORY);
            historyNode.removeNode();
        }
        historyNode = whereToSave.node(PREF_HISTORY);
        int i = 0;
        while (i < items.length) {
            String next = items[i];
            Preferences child = whereToSave.node(PREF_HISTORY + i);
            child.put("value", next);
            ++i;
        }
    }
}

