/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.DomainManager;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.RepositoryDomain;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreePathViewerSorter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class DelegatingTreePathSorter
extends TreePathViewerSorter {
    private DomainManager fDomainManager;

    public DelegatingTreePathSorter(DomainManager domainManager) {
        this.fDomainManager = domainManager;
    }

    public int category(TreePath parentPath, Object element) {
        ViewerSorter sorter;
        if (element instanceof RepositoryDomain) {
            return 0;
        }
        if (this.fDomainManager.getCategory().isCategoryElement(element)) {
            return 1;
        }
        if (parentPath == null) {
            Domain domain = this.fDomainManager.getDomain(element);
            if (domain == null) {
                return 1;
            }
            return 1000;
        }
        if (parentPath.getSegmentCount() > 1 && parentPath.getSegment(1) instanceof DomainSubtreeRoot) {
            DomainSubtreeRoot domainroot = (DomainSubtreeRoot)parentPath.getSegment(1);
            Domain domain = domainroot.getDomain();
            ViewerSorter sorter2 = domain.getSorter();
            if (sorter2 != null) {
                if (sorter2 instanceof TreePathViewerSorter) {
                    return ((TreePathViewerSorter)sorter2).category(parentPath, element);
                }
                return sorter2.category(element);
            }
            return super.category(parentPath, element);
        }
        Domain domain = this.fDomainManager.getDomain(element);
        if (domain != null && (sorter = domain.getSorter()) != null) {
            return sorter.category(element);
        }
        return super.category(parentPath, element);
    }

    public int compare(Viewer viewer, TreePath parentPath, Object e1, Object e2) {
        Domain domain;
        ViewerSorter sorter;
        if (parentPath == null) {
            int cat2;
            int cat1 = this.category(null, e1);
            if (cat1 != (cat2 = this.category(null, e2))) {
                return cat1 - cat2;
            }
            return super.compare(viewer, null, e1, e2);
        }
        if (parentPath.getSegmentCount() > 1 && parentPath.getSegment(1) instanceof DomainSubtreeRoot && (sorter = (domain = ((DomainSubtreeRoot)parentPath.getSegment(1)).getDomain()).getSorter()) != null) {
            try {
                if (sorter instanceof TreePathViewerSorter) {
                    return ((TreePathViewerSorter)sorter).compare(viewer, parentPath, e1, e2);
                }
                return sorter.compare(viewer, e1, e2);
            }
            catch (Throwable t) {
                ProcessRCPUIPlugin.getDefault().log(Messages.DelegatingTreePathSorter_0, t);
            }
        }
        if (!this.fDomainManager.getCategory().isCategoryElement(parentPath.getFirstSegment()) && (domain = this.fDomainManager.getDomain(parentPath.getFirstSegment())) != null && (sorter = domain.getSorter()) != null) {
            try {
                if (sorter instanceof TreePathViewerSorter) {
                    return ((TreePathViewerSorter)sorter).compare(viewer, parentPath, e1, e2);
                }
                return sorter.compare(viewer, e1, e2);
            }
            catch (Throwable t) {
                ProcessRCPUIPlugin.getDefault().log(Messages.DelegatingTreePathSorter_1, t);
            }
        }
        return super.compare(viewer, parentPath, e1, e2);
    }
}

