/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedListener;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.process.internal.rcp.ui.DomainManager;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.ILicenseService;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public abstract class AbstractDelegatingTreePathContentProvider
extends ElementRemovedNotifierImpl
implements ITreePathContentProvider,
ITreeContentProvider,
IDeferredWorkbenchAdapter,
IElementRemovedListener {
    protected static final Object[] EMPTY = new Object[0];
    protected DomainManager fDomainManager;
    protected DeferredTreeContentManager fContentManager;
    protected TreeViewer fViewer;
    protected Category fCategory;
    protected Map fInputChangedForDomain;

    public AbstractDelegatingTreePathContentProvider(DomainManager domainManager, Category category) {
        this.fDomainManager = domainManager;
        this.setCategory(category);
    }

    public void handleElementRemoved(Object element) {
        this.fireElementRemoved(element);
    }

    public ISchedulingRule getRule(Object object) {
        return new ThereCanBeOnlyOne();
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object object) {
        return null;
    }

    protected DeferredTreeContentManager getContentManager() {
        if (this.fContentManager == null && this.fViewer != null) {
            this.fContentManager = new DeferredTreeContentManager(this, (AbstractTreeViewer)this.fViewer){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (AbstractDelegatingTreePathContentProvider.this.hasChildren(element)) {
                        return AbstractDelegatingTreePathContentProvider.this;
                    }
                    return super.getAdapter(element);
                }

                protected String getFetchJobName(Object parent, IDeferredWorkbenchAdapter adapter) {
                    if (adapter.getLabel(parent) == null) {
                        return Messages.DelegatingTreePathContentProvider_3;
                    }
                    return super.getFetchJobName(parent, adapter);
                }
            };
        }
        return this.fContentManager;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children;
        DeferredTreeContentManager contentManager = this.getContentManager();
        if (contentManager != null && (children = contentManager.getChildren(parentElement)) != null) {
            return children;
        }
        return EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        block9: {
            monitor.beginTask("", 1000);
            try {
                TreeViewer viewer;
                Object[] children = this.computeChildren(object, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 900));
                collector.add(children, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                final ArrayList<Domain> domains = new ArrayList<Domain>();
                int i = 0;
                while (i < children.length) {
                    Object child = children[i];
                    if (child instanceof DomainSubtreeRoot) {
                        domains.add(((DomainSubtreeRoot)child).getDomain());
                    }
                    ++i;
                }
                if (domains.size() <= 0) break block9;
                AbstractDelegatingTreePathContentProvider abstractDelegatingTreePathContentProvider = this;
                synchronized (abstractDelegatingTreePathContentProvider) {
                    viewer = this.fViewer;
                }
                if (viewer != null) {
                    this.asyncExec(viewer.getControl(), new Runnable(){

                        public void run() {
                            if (AbstractDelegatingTreePathContentProvider.this.fInputChangedForDomain == null) {
                                return;
                            }
                            for (Domain domain : domains) {
                                try {
                                    AbstractDelegatingTreePathContentProvider.this.callInputChanged(domain);
                                }
                                catch (Throwable e) {
                                    AbstractDelegatingTreePathContentProvider.this.discardDomain(domain, e, true, true);
                                }
                            }
                        }
                    });
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void asyncExec(final Control control, final Runnable runnable) {
        block3: {
            if (control != null && !control.isDisposed()) {
                try {
                    control.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!control.isDisposed()) {
                                runnable.run();
                            }
                        }
                    });
                }
                catch (SWTException e) {
                    if (e.code == 24) break block3;
                    throw e;
                }
            }
        }
    }

    protected abstract Object[] computeChildren(Object var1, IElementCollector var2, IProgressMonitor var3);

    public String[] assertLicenses(final String[] domainIds, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        if (teamRepository == null) {
            return new String[domainIds.length];
        }
        IClientLibraryContext context = (IClientLibraryContext)teamRepository;
        final ILicenseService licenseService = (ILicenseService)context.getServiceInterface(ILicenseService.class);
        return (String[])context.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return licenseService.checkLicenses(domainIds);
            }
        }, monitor);
    }

    public boolean hasChildren(Object parentElement) {
        return !(parentElement instanceof PendingUpdateAdapter);
    }

    public Object getParent(Object child) {
        return null;
    }

    protected void setCategory(Category layoutCategory) {
        this.fCategory = layoutCategory;
        this.fCategory.addElementRemovedListener(this);
    }

    public Category getCategory() {
        return this.fCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discardDomain(Domain domain, Throwable e, boolean refresh, boolean log) {
        if (log) {
            ProcessRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.DelegatingTreePathContentProvider2_0, (Object)domain.getName()), e);
        }
        AbstractDelegatingTreePathContentProvider abstractDelegatingTreePathContentProvider = this;
        synchronized (abstractDelegatingTreePathContentProvider) {
            if (this.fDomainManager != null) {
                this.fDomainManager.unloadDomain(domain, refresh);
                this.fInputChangedForDomain.remove(domain);
            }
        }
    }

    protected void callInputChanged(Domain domain) throws Throwable {
        if (this.fInputChangedForDomain == null) {
            return;
        }
        Boolean needToCall = (Boolean)this.fInputChangedForDomain.get(domain);
        if (needToCall == null || needToCall.booleanValue()) {
            domain.getContentProvider().inputChanged((Viewer)this.fViewer, null, domain.getRoot());
            this.fInputChangedForDomain.put(domain, Boolean.FALSE);
        }
    }

    public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
        if (this.fDomainManager == null) {
            this.fDomainManager = (DomainManager)((Object)newInput);
        }
        this.fInputChangedForDomain = new HashMap();
        if (this.fDomainManager != null) {
            Domain[] domains = this.fDomainManager.getDomains();
            int i = 0;
            while (i < domains.length) {
                this.fInputChangedForDomain.put(domains[i], Boolean.TRUE);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Domain[] domains = this.fDomainManager.getDomains();
        int i = 0;
        while (i < domains.length) {
            ITreePathContentProvider cp = domains[i].getContentProvider();
            if (cp instanceof IElementRemovedNotifier) {
                IElementRemovedNotifier notifier = (IElementRemovedNotifier)cp;
                notifier.removeElementRemoveListener((IElementRemovedListener)this);
            }
            ++i;
        }
        this.fCategory.removeElementRemoveListener(this);
        AbstractDelegatingTreePathContentProvider abstractDelegatingTreePathContentProvider = this;
        synchronized (abstractDelegatingTreePathContentProvider) {
            this.fDomainManager = null;
            this.fInputChangedForDomain = null;
            if (this.fCategory != null) {
                this.fCategory.dispose();
            }
            this.fCategory = null;
            this.fViewer = null;
        }
        this.removeAllRemoveListeners();
    }

    protected String[] getDomainIds(Domain[] supportingDomains) {
        ArrayList<String> domainIds = new ArrayList<String>(supportingDomains.length);
        int i = 0;
        while (i < supportingDomains.length) {
            Domain domain = supportingDomains[i];
            try {
                domainIds.add(domain.getId());
            }
            catch (Throwable e) {
                this.discardDomain(domain, e, false, true);
            }
            ++i;
        }
        return domainIds.toArray(new String[domainIds.size()]);
    }

    private final class ThereCanBeOnlyOne
    implements ISchedulingRule {
        private ThereCanBeOnlyOne() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ThereCanBeOnlyOne;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

