/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver.editors;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RequireWorkItemAspectEditor
extends OperationDetailsAspectEditor {
    private static final String TAG_REQUIRES = "requires";
    private static final String TAG_WORKITEM = "workitem";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_OWNER = "owner";
    private static final String ATTR_TARGET = "target";
    private static final String VAL_COMMENT = "comment";
    private static final String VAL_WORKITEM = "workitem";
    private static final String VAL_WORKITEM_OR_COMMENT = "workitem-or-comment";
    private static final String VAL_WORKITEM_AND_COMMENT = "workitem-and-comment";
    private static final String VAL_OPTIONAL = "optional";
    private static final String VAL_REQUIRED = "required";
    private static final String VAL_CURRENT_CONTRIBUTOR = "current-contributor";
    private static final String VAL_CURRENT_ITERATION = "current-iteration";
    private static final int COMMENT = 0;
    private static final int WORKITEM = 1;
    private static final int EITHER = 2;
    private static final int BOTH = 3;
    private static final int OPTIONAL = 0;
    private static final int REQUIRED = 1;
    private static final int CURRENT = 2;
    private Model fModel;
    private Button[] fRequiresButtons;
    private Button[] fOwnerButtons;
    private Button[] fTargetButtons;
    private Label fTargetLabel;
    private Label fOwnerLabel;

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().spacing(5, 8).applyTo(parent);
        Label heading = toolkit.createLabel(parent, Messages.RequireWorkItemAspectEditor_0);
        heading.setFont(this.getBoldFont());
        toolkit.createLabel(parent, Messages.RequireWorkItemAspectEditor_1);
        Composite requiresComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(10, 0).spacing(5, 8).numColumns(4).applyTo(requiresComposite);
        this.fRequiresButtons = new Button[4];
        this.fRequiresButtons[0] = this.createRadioButton(toolkit, requiresComposite, Messages.RequireWorkItemAspectEditor_2, ATTR_VALUE, 0);
        this.fRequiresButtons[1] = this.createRadioButton(toolkit, requiresComposite, Messages.RequireWorkItemAspectEditor_3, ATTR_VALUE, 1);
        this.fRequiresButtons[2] = this.createRadioButton(toolkit, requiresComposite, Messages.RequireWorkItemAspectEditor_4, ATTR_VALUE, 2);
        this.fRequiresButtons[3] = this.createRadioButton(toolkit, requiresComposite, Messages.RequireWorkItemAspectEditor_5, ATTR_VALUE, 3);
        this.fOwnerLabel = toolkit.createLabel(parent, Messages.RequireWorkItemAspectEditor_6);
        Composite ownerComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(10, 0).spacing(5, 8).numColumns(3).applyTo(ownerComposite);
        this.fOwnerButtons = new Button[3];
        this.fOwnerButtons[0] = this.createRadioButton(toolkit, ownerComposite, Messages.RequireWorkItemAspectEditor_7, ATTR_OWNER, 0);
        this.fOwnerButtons[1] = this.createRadioButton(toolkit, ownerComposite, Messages.RequireWorkItemAspectEditor_8, ATTR_OWNER, 1);
        this.fOwnerButtons[2] = this.createRadioButton(toolkit, ownerComposite, Messages.RequireWorkItemAspectEditor_9, ATTR_OWNER, 2);
        this.fTargetLabel = toolkit.createLabel(parent, Messages.RequireWorkItemAspectEditor_10);
        Composite targetComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(10, 0).spacing(5, 8).numColumns(3).applyTo(targetComposite);
        this.fTargetButtons = new Button[3];
        this.fTargetButtons[0] = this.createRadioButton(toolkit, targetComposite, Messages.RequireWorkItemAspectEditor_11, ATTR_TARGET, 0);
        this.fTargetButtons[1] = this.createRadioButton(toolkit, targetComposite, Messages.RequireWorkItemAspectEditor_12, ATTR_TARGET, 1);
        this.fTargetButtons[2] = this.createRadioButton(toolkit, targetComposite, Messages.RequireWorkItemAspectEditor_13, ATTR_TARGET, 2);
        this.updateUI();
    }

    private Button createRadioButton(FormToolkit toolkit, Composite parent, String text, final String attr, final int val) {
        final Button button = toolkit.createButton(parent, text, 16);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    RequireWorkItemAspectEditor.this.handleChoice(attr, val);
                }
            }
        });
        return button;
    }

    private void handleChoice(String attr, int val) {
        if (ATTR_VALUE == attr) {
            this.fModel.requires = val;
            this.setDirty();
            this.updateEnablement();
        } else if (ATTR_OWNER == attr) {
            this.setDirty();
            this.fModel.owner = val;
        } else if (ATTR_TARGET == attr) {
            this.setDirty();
            this.fModel.target = val;
        } else {
            Assert.isTrue((boolean)false, (String)Messages.RequireWorkItemAspectEditor_14);
        }
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    public void updateUI() {
        int i = 0;
        while (i < this.fRequiresButtons.length) {
            this.fRequiresButtons[i].setSelection(i == this.fModel.requires);
            ++i;
        }
        i = 0;
        while (i < this.fOwnerButtons.length) {
            this.fOwnerButtons[i].setSelection(i == this.fModel.owner);
            ++i;
        }
        i = 0;
        while (i < this.fTargetButtons.length) {
            this.fTargetButtons[i].setSelection(i == this.fModel.target);
            ++i;
        }
        this.updateEnablement();
    }

    private void updateEnablement() {
        boolean enable = this.fModel.requires != 0;
        this.fOwnerLabel.setEnabled(enable);
        int i = 0;
        while (i < this.fOwnerButtons.length) {
            this.fOwnerButtons[i].setEnabled(enable);
            ++i;
        }
        this.fTargetLabel.setEnabled(enable);
        i = 0;
        while (i < this.fTargetButtons.length) {
            this.fTargetButtons[i].setEnabled(enable);
            ++i;
        }
    }

    public void dispose() {
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.fModel = new Model();
    }

    public void restoreState(IMemento memento) {
        this.fModel.readFrom(memento);
    }

    public boolean saveState(IMemento memento) {
        IMemento requiresMemento = memento.createChild(TAG_REQUIRES);
        requiresMemento.putString(ATTR_VALUE, this.fModel.getRequiresString());
        if (this.fModel.requires != 0) {
            IMemento workitemMemento = requiresMemento.createChild("workitem");
            workitemMemento.putString(ATTR_OWNER, this.fModel.getOwnerString());
            workitemMemento.putString(ATTR_TARGET, this.fModel.getTargetString());
        }
        return true;
    }

    private static class Model {
        int requires;
        int owner;
        int target;

        private Model() {
        }

        public void readFrom(IMemento memento) {
            this.requires = 1;
            this.owner = 0;
            this.target = 0;
            IMemento requiresMemento = memento.getChild(RequireWorkItemAspectEditor.TAG_REQUIRES);
            if (requiresMemento != null) {
                this.requires = this.parseRequires(requiresMemento.getString(RequireWorkItemAspectEditor.ATTR_VALUE));
                IMemento workitemMemento = requiresMemento.getChild("workitem");
                if (workitemMemento != null) {
                    this.owner = this.parseOwner(workitemMemento.getString(RequireWorkItemAspectEditor.ATTR_OWNER));
                    this.target = this.parseTarget(workitemMemento.getString(RequireWorkItemAspectEditor.ATTR_TARGET));
                }
            }
        }

        private int parseRequires(String val) {
            if (RequireWorkItemAspectEditor.VAL_COMMENT.equals(val)) {
                return 0;
            }
            if ("workitem".equals(val)) {
                return 1;
            }
            if (RequireWorkItemAspectEditor.VAL_WORKITEM_OR_COMMENT.equals(val)) {
                return 2;
            }
            if (RequireWorkItemAspectEditor.VAL_WORKITEM_AND_COMMENT.equals(val)) {
                return 3;
            }
            return 0;
        }

        private int parseOwner(String val) {
            if (RequireWorkItemAspectEditor.VAL_OPTIONAL.equals(val)) {
                return 0;
            }
            if (RequireWorkItemAspectEditor.VAL_REQUIRED.equals(val)) {
                return 1;
            }
            if (RequireWorkItemAspectEditor.VAL_CURRENT_CONTRIBUTOR.equals(val)) {
                return 2;
            }
            return 0;
        }

        private int parseTarget(String val) {
            if (RequireWorkItemAspectEditor.VAL_OPTIONAL.equals(val)) {
                return 0;
            }
            if (RequireWorkItemAspectEditor.VAL_REQUIRED.equals(val)) {
                return 1;
            }
            if (RequireWorkItemAspectEditor.VAL_CURRENT_ITERATION.equals(val)) {
                return 2;
            }
            return 0;
        }

        public String getRequiresString() {
            switch (this.requires) {
                case 0: {
                    return RequireWorkItemAspectEditor.VAL_COMMENT;
                }
                case 1: {
                    return "workitem";
                }
                case 2: {
                    return RequireWorkItemAspectEditor.VAL_WORKITEM_OR_COMMENT;
                }
                case 3: {
                    return RequireWorkItemAspectEditor.VAL_WORKITEM_AND_COMMENT;
                }
            }
            throw new IllegalStateException();
        }

        public String getOwnerString() {
            switch (this.owner) {
                case 0: {
                    return RequireWorkItemAspectEditor.VAL_OPTIONAL;
                }
                case 1: {
                    return RequireWorkItemAspectEditor.VAL_REQUIRED;
                }
                case 2: {
                    return RequireWorkItemAspectEditor.VAL_CURRENT_CONTRIBUTOR;
                }
            }
            throw new IllegalStateException();
        }

        public String getTargetString() {
            switch (this.target) {
                case 0: {
                    return RequireWorkItemAspectEditor.VAL_OPTIONAL;
                }
                case 1: {
                    return RequireWorkItemAspectEditor.VAL_REQUIRED;
                }
                case 2: {
                    return RequireWorkItemAspectEditor.VAL_CURRENT_ITERATION;
                }
            }
            throw new IllegalStateException();
        }
    }
}

