/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver.editors;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor2;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.Messages;
import com.ibm.team.process.internal.ide.ui.editors.util.DeferredElementListSelectionDialog;
import com.ibm.team.process.internal.ide.ui.editors.util.DisplayHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.scm.common.internal.query.BaseComponentQueryModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComponentScopeDefinitionBlock {
    private static final String TAG_COMPONENTS = "components";
    private static final String TAG_COMPONENT = "component";
    private static final String ATTR_NAME = "name";
    private TableViewer fComponentList;
    private DeferredElementListSelectionDialog fDialog;

    public static List readComponents(IMemento memento) {
        IMemento[] component;
        ArrayList<String> componentNames = new ArrayList<String>();
        IMemento componentsMemento = memento.getChild(TAG_COMPONENTS);
        if (componentsMemento != null && (component = componentsMemento.getChildren(TAG_COMPONENT)) != null) {
            componentNames.clear();
            int i = 0;
            while (i < component.length) {
                IMemento componentMemento = component[i];
                String componentName = componentMemento.getString(ATTR_NAME);
                if (ComponentScopeDefinitionBlock.isNotNull(componentName)) {
                    componentNames.add(componentName);
                }
                ++i;
            }
        }
        return componentNames;
    }

    public static boolean saveComponents(List componentNames, IMemento memento) {
        if (componentNames != null && !componentNames.isEmpty()) {
            IMemento components = null;
            for (String componentName : componentNames) {
                if (!ComponentScopeDefinitionBlock.isNotNull(componentName)) continue;
                if (components == null) {
                    components = memento.createChild(TAG_COMPONENTS);
                }
                IMemento child = components.createChild(TAG_COMPONENT);
                child.putString(ATTR_NAME, componentName);
            }
        }
        return true;
    }

    private static boolean isNotNull(String string) {
        return string != null && string.trim().length() > 0;
    }

    public TableViewer createControl(Composite parent, FormToolkit toolkit, final ProcessAspectEditor2 editor) {
        Label label = toolkit.createLabel(parent, Messages.ComponentScopeDefinitionBlock_1);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)label);
        this.fComponentList = new TableViewer(parent, 2818);
        this.fComponentList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fComponentList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        int h = this.fComponentList.getTable().getItemHeight() * 2;
        h = this.fComponentList.getTable().computeTrim((int)0, (int)0, (int)500, (int)h).height;
        GridDataFactory.fillDefaults().grab(true, true).hint(200, h).applyTo((Control)this.fComponentList.getTable());
        Composite buttonComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().align(131072, 128).grab(false, true).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(buttonComposite);
        Button addComponentButton = toolkit.createButton(buttonComposite, Messages.ComponentScopeDefinitionBlock_2, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)addComponentButton);
        addComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentScopeDefinitionBlock.this.addComponents(editor, (List)ComponentScopeDefinitionBlock.this.fComponentList.getInput())) {
                    editor.setDirty();
                    ComponentScopeDefinitionBlock.this.fComponentList.refresh();
                }
            }
        });
        final Button removeComponentButton = toolkit.createButton(buttonComposite, Messages.ComponentScopeDefinitionBlock_3, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)removeComponentButton);
        removeComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentScopeDefinitionBlock.this.removeComponents(editor, (List)ComponentScopeDefinitionBlock.this.fComponentList.getInput())) {
                    editor.setDirty();
                    ComponentScopeDefinitionBlock.this.fComponentList.refresh();
                }
            }
        });
        removeComponentButton.setEnabled(false);
        this.fComponentList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                removeComponentButton.setEnabled(selection != null && !selection.isEmpty());
            }
        });
        return this.fComponentList;
    }

    private boolean addComponents(ProcessAspectEditor2 editor, List componentNameModel) {
        ProcessAspect aspect = editor.getAspect();
        IProcessItem underlyingProcessItem = aspect.getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        final ITeamRepository repository = (ITeamRepository)underlyingProcessItem.getOrigin();
        Job fetchComponentNames = new Job(Messages.ComponentScopeDefinitionBlock_4){

            protected IStatus run(IProgressMonitor monitor) {
                final ArrayList<String> componentNames = new ArrayList<String>();
                try {
                    IClientLibraryContext context = (IClientLibraryContext)repository;
                    context.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                        public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                            this.queryComponents(componentNames, monitor);
                            return null;
                        }
                    }, monitor);
                }
                catch (TeamRepositoryException x) {
                    DefinitionsIdeUIPlugin.getDefault().log(x);
                    componentNames.clear();
                    componentNames.add(Messages.ComponentScopeDefinitionBlock_5);
                }
                DisplayHelper.asyncExec((Control)ComponentScopeDefinitionBlock.this.fComponentList.getControl(), (Runnable)new Runnable(){

                    public void run() {
                        ComponentScopeDefinitionBlock.this.fDialog.setFetchingDone();
                        ComponentScopeDefinitionBlock.this.fDialog.setListElements(componentNames.toArray());
                    }
                });
                return Status.OK_STATUS;
            }

            private void queryComponents(List componentNames, IProgressMonitor monitor) throws TeamRepositoryException {
                BaseComponentQueryModel.ComponentQueryModel cqm = BaseComponentQueryModel.ComponentQueryModel.ROOT;
                IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)cqm);
                query.select((ISelectionElement)cqm.name());
                IClientLibraryContext context = (IClientLibraryContext)repository;
                IQueryService queryService = (IQueryService)context.getServiceInterface(IQueryService.class);
                IDataQueryPage data = queryService.queryData(query, IQueryService.EMPTY_PARAMETERS, 512);
                while (data != null) {
                    int i = 0;
                    while (i < data.getSize()) {
                        IDataRow values = data.getRow(i);
                        String componentName = values.getString(0);
                        if (ComponentScopeDefinitionBlock.isNotNull(componentName)) {
                            componentNames.add(componentName);
                        }
                        ++i;
                    }
                    if (data.hasNext()) {
                        UUID token = data.getToken();
                        int nextStartPosition = data.getNextStartPosition();
                        data = (IDataQueryPage)queryService.fetchPage(token, nextStartPosition, 512);
                        continue;
                    }
                    data = null;
                }
            }
        };
        this.fDialog = new DeferredElementListSelectionDialog(fetchComponentNames, this.fComponentList.getControl().getShell(), (ILabelProvider)new LabelProvider());
        this.fDialog.setElements((Object[])new String[]{Messages.ComponentScopeDefinitionBlock_6});
        this.fDialog.setTitle(Messages.ComponentScopeDefinitionBlock_7);
        this.fDialog.setMessage(Messages.ComponentScopeDefinitionBlock_8);
        this.fDialog.setMultipleSelection(true);
        fetchComponentNames.setUser(false);
        fetchComponentNames.schedule();
        if (this.fDialog.open() != 0) {
            fetchComponentNames.cancel();
            return false;
        }
        fetchComponentNames.cancel();
        boolean added = false;
        Object[] result = this.fDialog.getResult();
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                String name;
                if (result[i] instanceof String && !componentNameModel.contains(name = (String)result[i])) {
                    componentNameModel.add(name);
                    added = true;
                }
                ++i;
            }
        }
        return added;
    }

    private boolean removeComponents(ProcessAspectEditor2 editor, List componentNameModel) {
        ISelection selection = this.fComponentList.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return componentNameModel.removeAll(ss.toList());
        }
        return false;
    }
}

