/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.junit.JUnitCore;
import org.eclipse.jdt.junit.TestRunListener;
import org.eclipse.jdt.junit.model.ITestCaseElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.junit.model.ITestRunSession;

public class TestRunManager {
    private ProcessTestRunListener fTestRunListener = new ProcessTestRunListener();
    private ElementChangedListener fElementChangedListener = new ElementChangedListener();
    private TestRun fRecordedTestRun;

    public void start() {
        JUnitCore.addTestRunListener((TestRunListener)this.fTestRunListener);
        JavaCore.addElementChangedListener((IElementChangedListener)this.fElementChangedListener);
    }

    public void stop() {
        JUnitCore.removeTestRunListener((TestRunListener)this.fTestRunListener);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fElementChangedListener);
    }

    public synchronized boolean wereTestsRun(String testClassName) {
        Set runTestClasses;
        if (this.fRecordedTestRun != null && (runTestClasses = this.fRecordedTestRun.getRunTestClasses()) != null) {
            return testClassName == null ? true : runTestClasses.contains(testClassName);
        }
        return false;
    }

    public synchronized Map getFailedTests(String testClassName) {
        if (this.fRecordedTestRun != null) {
            HashMap result = new HashMap();
            Map failedTests = this.fRecordedTestRun.getFailedTests();
            if (failedTests != null) {
                for (Map.Entry entry : failedTests.entrySet()) {
                    String failedTestClassName = (String)entry.getKey();
                    if (!testClassName.equalsIgnoreCase(failedTestClassName)) continue;
                    result.put(entry.getKey(), entry.getValue());
                }
                if (!result.isEmpty()) {
                    return result;
                }
            }
        }
        return null;
    }

    private synchronized void testsRan(TestRun run) {
        this.fRecordedTestRun = run;
    }

    private synchronized void codeChanged() {
        this.fRecordedTestRun = null;
        this.fTestRunListener.ignoreCurrentRun();
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            this.processDelta(event.getDelta());
        }

        private boolean processDelta(IJavaElementDelta delta) {
            int kind = delta.getKind();
            int details = delta.getFlags();
            int type = delta.getElement().getElementType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (kind == 4 && details == 8) break;
                    TestRunManager.this.codeChanged();
                    return false;
                }
                case 5: {
                    if ((details & 0x10000) != 0) {
                        return true;
                    }
                    TestRunManager.this.codeChanged();
                    return false;
                }
                case 6: {
                    return true;
                }
                default: {
                    TestRunManager.this.codeChanged();
                    return false;
                }
            }
            IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
            if (affectedChildren == null) {
                return true;
            }
            int i = 0;
            while (i < affectedChildren.length) {
                if (!this.processDelta(affectedChildren[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private class ProcessTestRunListener
    extends TestRunListener {
        private TestRun fCurrentRun;
        private boolean fIgnore;

        private ProcessTestRunListener() {
        }

        public void sessionStarted(ITestRunSession session) {
            this.fCurrentRun = new TestRun();
            this.fIgnore = false;
        }

        public void sessionFinished(ITestRunSession session) {
            if (!this.fIgnore) {
                TestRunManager.this.testsRan(this.fCurrentRun);
            }
            this.cleanup();
        }

        public void testCaseFinished(ITestCaseElement testCaseElement) {
            if (this.fCurrentRun != null) {
                ITestElement.Result testResult = testCaseElement.getTestResult(false);
                boolean success = testResult.equals(ITestElement.Result.OK);
                this.fCurrentRun.testFinished(testCaseElement.getTestClassName(), testCaseElement.getTestMethodName(), success, false);
            }
        }

        public void ignoreCurrentRun() {
            this.fIgnore = true;
        }

        private void cleanup() {
            this.fCurrentRun = null;
            this.fIgnore = false;
        }
    }

    private static class TestRun {
        private Map fFailedTests;
        private Set fRunTestClasses;

        private TestRun() {
        }

        public void testFinished(String testClassName, String testMethodName, boolean success, boolean overwrite) {
            if (!success) {
                if (this.fFailedTests == null) {
                    this.fFailedTests = new HashMap();
                }
                this.fFailedTests.put(testClassName, testMethodName);
            } else if (this.fFailedTests != null && overwrite) {
                this.fFailedTests.remove(testClassName);
                if (this.fFailedTests.isEmpty()) {
                    this.fFailedTests = null;
                }
            } else if (success && testMethodName != null) {
                if (this.fRunTestClasses == null) {
                    this.fRunTestClasses = new HashSet();
                }
                this.fRunTestClasses.add(testClassName);
            }
        }

        public Map getFailedTests() {
            return this.fFailedTests;
        }

        public Set getRunTestClasses() {
            return this.fRunTestClasses;
        }
    }
}

