/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.AbstractFileAdvisor;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequiredContentAdvisor
extends AbstractFileAdvisor {
    private static final String TAG_REQUIRED_TEXT = "requiredText";
    private static final String TAG_INSERT_TEXT = "insertText";
    private static final String ATTR_TEXT = "text";
    private static final String TAG_FILE_PATTERN = "filePattern";
    private static final String ATTR_PATTERN = "pattern";
    public static final String DATA_ATTR_REQUIRED_CONTENT = "requiredContent";
    public static final String DATA_ATTR_INSERT_TEXT = "insertText";
    public static final String ID_REQUIRED_CONTENT_PROBLEM = "com.ibm.team.process.internal.definitions.requiredContentProblem";
    public static final String ID_REQUIRED_CONTENT = "com.ibm.team.process.deliver.requiredContent";
    private List fFilesMissingContent;
    private String fFilePattern;
    private String fRequiredText;
    private String fInsertText;

    protected void initialize(IProcessConfigurationElement advisorConfig) {
        super.initialize(advisorConfig);
        IProcessConfigurationElement[] children = advisorConfig.getChildren();
        int i = 0;
        while (i < children.length) {
            IProcessConfigurationElement child = children[i];
            String elementName = child.getName();
            if (elementName.equals(TAG_FILE_PATTERN)) {
                this.fFilePattern = child.getAttribute(ATTR_PATTERN);
            } else if (elementName.equals(TAG_REQUIRED_TEXT)) {
                this.fRequiredText = child.getAttribute(ATTR_TEXT);
            } else if (elementName.equals("insertText")) {
                this.fInsertText = child.getAttribute(ATTR_TEXT);
            }
            ++i;
        }
    }

    public String getFilePattern() {
        return this.fFilePattern;
    }

    public String getRequiredText() {
        return this.fRequiredText;
    }

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fFilesMissingContent = new ArrayList();
        super.run(operation, advisorConfiguration, collector, monitor);
        if (this.fFilesMissingContent.size() > 0) {
            IAdvisorInfo problem = collector.createProblemInfo(Messages.RequiredContentAdvisor_0, Messages.RequiredContentAdvisor_1, ID_REQUIRED_CONTENT_PROBLEM);
            problem.setProblemObject((Object)this.fFilesMissingContent);
            Exception dataException = null;
            try {
                this.setProblemData(problem, null, null, null, null);
            }
            catch (ParserConfigurationException e) {
                dataException = e;
            }
            catch (TransformerException e) {
                dataException = e;
            }
            catch (IOException e) {
                dataException = e;
            }
            collector.addInfo((IReportInfo)problem);
            if (dataException != null) {
                IAdvisorInfo exceptionInfo = collector.createExceptionInfo(Messages.RequiredContentAdvisor_2, (Throwable)dataException);
                exceptionInfo.setSeverity(2);
                collector.addInfo((IReportInfo)exceptionInfo);
            }
        }
    }

    protected IReportInfo getProblem(IFile file, IAdvisorInfoCollector collector, IProgressMonitor monitor) {
        IPath fullPath = file.getFullPath();
        if (this.fRequiredText != null && this.fFilePattern != null && fullPath.toString().matches(this.fFilePattern)) {
            try {
                InputStream contents = file.getContents();
                if (!this.streamContains(contents, file.getCharset(), this.fRequiredText, monitor)) {
                    this.fFilesMissingContent.add(file);
                }
            }
            catch (CoreException e) {
                return collector.createExceptionInfo(NLS.bind((String)Messages.RequiredContentAdvisor_3, (Object)file.getFullPath().toString()), (Throwable)e);
            }
            catch (IOException e) {
                return collector.createExceptionInfo(NLS.bind((String)Messages.RequiredContentAdvisor_3, (Object)file.getFullPath().toString()), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean streamContains(InputStream stream, String charset, String requiredText, IProgressMonitor monitor) throws IOException {
        try {
            if (requiredText.length() == 0) {
                return true;
            }
            InputStreamReader reader = new InputStreamReader(stream, charset);
            monitor.beginTask(Messages.RequiredContentAdvisor_4, 1000);
            int requiredIndex = 0;
            int ch = reader.read();
            while (ch != -1) {
                if (requiredIndex == requiredText.length()) {
                    return true;
                }
                requiredIndex = requiredText.charAt(requiredIndex) == (char)ch ? ++requiredIndex : 0;
                ch = reader.read();
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            return false;
        }
        finally {
            monitor.done();
            stream.close();
        }
    }

    protected void appendToProblemData(Element dataElement, Object custom, Document doc) {
        dataElement.setAttribute(DATA_ATTR_REQUIRED_CONTENT, this.fRequiredText);
        dataElement.setAttribute("insertText", this.fInsertText);
    }
}

