/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.process.client.IAdvisorProblemResolutionDelegate;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ProhibitUnusedImportsProblemResolutionDelegate
implements IAdvisorProblemResolutionDelegate {
    public boolean run(IAdvisorInfo problem, IProgressMonitor monitor) {
        List filesWithUnusedImports = (List)problem.getProblemObject();
        final ArrayList<IJavaElement> compilationUnits = new ArrayList<IJavaElement>();
        for (IFile file : filesWithUnusedImports) {
            IJavaElement javaElement = JavaCore.create((IFile)file);
            if (!(javaElement instanceof ICompilationUnit)) continue;
            compilationUnits.add(javaElement);
        }
        final boolean[] result = new boolean[1];
        if (compilationUnits.size() > 0) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    IWorkbenchSite workbenchSite = ProhibitUnusedImportsProblemResolutionDelegate.this.getWorkbenchSite();
                    if (workbenchSite != null) {
                        OrganizeImportsAction action = new OrganizeImportsAction(workbenchSite);
                        action.runOnMultiple(compilationUnits.toArray(new ICompilationUnit[compilationUnits.size()]));
                        result[0] = true;
                    }
                }
            });
        }
        return result[0];
    }

    public boolean mayBeApplicable(IAdvisorInfo info) {
        Object problemObject = info.getProblemObject();
        return problemObject instanceof List && ((List)problemObject).size() > 0;
    }

    private IWorkbenchSite getWorkbenchSite() {
        IWorkbenchSite workbenchSite = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            workbenchSite = this.getWorkbenchSite(window);
        }
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (workbenchSite == null && i < windows.length) {
            workbenchSite = this.getWorkbenchSite(windows[i]);
            ++i;
        }
        return workbenchSite;
    }

    private IWorkbenchSite getWorkbenchSite(IWorkbenchWindow window) {
        IWorkbenchSite workbenchSite = null;
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            workbenchSite = this.getWorkbenchSite(page);
        }
        IWorkbenchPage[] pages = window.getPages();
        int i = 0;
        while (workbenchSite == null && i < pages.length) {
            workbenchSite = this.getWorkbenchSite(pages[i]);
            ++i;
        }
        return workbenchSite;
    }

    private IWorkbenchSite getWorkbenchSite(IWorkbenchPage page) {
        IWorkbenchPart part = page.getActivePart();
        if (part != null) {
            return part.getSite();
        }
        part = page.getActiveEditor();
        if (part != null) {
            return part.getSite();
        }
        IViewPart[] views = page.getViews();
        if (views.length > 0) {
            return views[0].getViewSite();
        }
        return null;
    }
}

